import 'package:account_center/common/res/colors.dart';
import 'package:account_center/common/utils/image_load.dart';
import 'package:account_center/page/enterprise/organization_structure/new_position_page/new_position_logic.dart';
import 'package:account_center/style/svg_path.dart';
import 'package:flutter/material.dart';
import 'package:flutter_clx_base/flutter_clx_base.dart';

class TabRoleDetailsPage extends StatelessWidget {
  final logic = Get.find<NewPositionLogic>();
  final state = Get.find<NewPositionLogic>().state;

  TabRoleDetailsPage({super.key});

  @override
  Widget build(BuildContext context) {
    return _proListView(context);
  }

  ///已添加产品列表
  Widget _proListView(context) {
    return CustomScrollView(
      slivers: [
        SliverFixedExtentList(
            delegate: SliverChildBuilderDelegate((context, index) {
              return _itemViewPro(state.roleList.getElement(index));
            }, childCount: state.roleList.length),
            itemExtent: 70),
        SliverToBoxAdapter(
          child: Container(
            padding: EdgeInsets.symmetric(horizontal: 10, vertical: 15),
            alignment: Alignment.topLeft,
            color: Colors.white,
            child: InkWell(
              onTap: () {
                logic.goToRoleListPage();
              },
              child: Row(
                children: [
                  Icon(
                    Icons.add,
                    color: RColors.mainContentColor,
                  ),
                  hGap5,
                  Expanded(
                      child: Text(
                    "添加角色",
                    style: TextStyle(
                        color: RColors.mainContentColor,
                        fontWeight: FontWeight.w500),
                  ))
                ],
              ),
            ),
          ),
        ),
      ],
    );
  }

  ///产品列表条目
  Widget _itemViewPro(dynamic item) {
    return Container(
      margin: EdgeInsets.only(bottom: 1),
      padding: EdgeInsets.symmetric(horizontal: 20, vertical: 10),
      color: Colors.white,
      child: Row(
        children: [
          InkWell(
            onTap: () {
              logic.deleteRole(item);
            },
            child: Icon(
              size: 24,
              Icons.remove_circle_outlined,
              color: Colors.red,
            ),
          ),
          hGap10,
          ImageLoad.svgTagIconByPath(SvgPath.roleIcon()),
          hGap15,
          Expanded(
              child: Text(
            item['roleName'] ?? '',
            style: TextStyle(fontSize: 16, fontWeight: FontWeight.bold),
          )),
        ],
      ),
    );
  }
}
