import 'package:account_center/api/base_model.dart';
import 'package:account_center/common/sp/sp_util.dart';
import 'package:account_center/widget/alert_util.dart';
import 'package:flutter_clx_base/flutter_clx_base.dart';

import 'update_company_name_state.dart';

class UpdateCompanyShortNameInfoLogic extends GetxController {
  final UpdateCompanyShortNameInfoState state =
      UpdateCompanyShortNameInfoState();

  @override
  void onInit() {
    super.onInit();
    state.title = Get.arguments['title'];
    state.shortName = Get.arguments['shortName'] ?? '';
    state.shortNameInitials = Get.arguments['shortNameInitials'] ?? '';
    state.controller.text =
        state.title == '企业简称' ? state.shortName : state.shortNameInitials;
  }

  void completed() {
    _uploadEnterprise();
  }

  void _uploadEnterprise() {
    Map<String, String?> params;
    if (state.title == '企业简称') {
      params = {
        'companyNo': getCompanyNo(),
        'shortName': state.controller.text,
        'shortNameInitials': state.shortNameInitials
      };
      state.shortName = state.controller.text;
    } else {
      params = {
        'companyNo': getCompanyNo(),
        'shortName': state.shortName,
        'shortNameInitials': state.controller.text
      };
      state.shortNameInitials = state.controller.text;
    }
    AlertUtil.showLoading();
    fetch(Method.post, url: HttpApi.updateCompanyShortNameInfo, params: params,
        onSuccess: (data) {
      AlertUtil.dismissLoading();
      ToastUtil.showToast('操作成功');
      Get.back(result: {
        'shortName': state.shortName,
        'shortNameInitials': state.shortNameInitials
      });
    }, onError: (msg, code) {
      AlertUtil.dismissLoading();
    });
  }
}
