import 'package:account_center/account_center.dart';
import 'package:account_center/api/base_model.dart';
import 'package:account_center/common/sp/sp_util.dart';
import 'package:account_center/page/account_company/company_auth/widget/common/comapny_http.dart';
import 'package:account_center/page/account_company/company_auth/widget/common/company_define.dart';

import 'new_enterprise_see_state.dart';

class NewEnterpriseSeeLogic extends GetxController {
  final NewEnterpriseSeeState state = NewEnterpriseSeeState();

  @override
  void onInit() {
    super.onInit();

    ///type 1.从企业信息进来  2.从创建企业记录列表进入
    state.companyNo = Get.arguments['companyNo'];
    state.type = Get.arguments['type'];
    _enterpriseInfoRequest();
    _requestCertificationMessage();
  }

  void goToBasicPage() {
    Get.toNamed(RouteConfig.enterpriseBasicSeePage, arguments: state.basicInfo);
  }

  void goToProxyPersonPage() {
    Get.toNamed(RouteConfig.enterpriseProxySeePage, arguments: state.proxyInfo);
  }

  void goToLegalPersonPage() {
    Get.toNamed(RouteConfig.enterpriseLegalSeePage, arguments: state.legalInfo);
  }

  void _enterpriseInfoRequest() {
    dynamic params;
    String url;
    if (state.type == 1) {
      params = {'companyNo': state.companyNo};
      url = HttpApi.getCompanyDetailByNo;
    } else {
      params = {'id': state.companyNo};
      url = HttpApi.newEnterpriseRecordDetails;
    }
    fetch(Method.get, queryParameters: params, url: url, onSuccess: (data) {
      if (data != null) {
        state.logoUrl = data['companyLogo'] ?? '';
        state.companyShortName = data['companyShortName'] ?? '';
        state.companyShortNameInitials = data['companyShortNameInitials'] ?? '';
        state.basicInfo = {
          'companyName': data['companyName'] ?? '',
          'companyType': data['companyType'] ?? 0,
          'companyGroupCode': data['companyGroupCode'],
          'bankPublicNumber': data['bankPublicNumber'],
          'bankName': data['bankName'],
          'companyAddress': data['companyAddress'],
          'companyBusinessImg': data['companyBusinessImg'],
          'businessStartDate': data['businessStartDate'],
          'businessEndDate': data['businessEndDate'],
          'businessLongTermFlag': data['businessLongTermFlag'],
          'businessExpiredFlag': data['businessExpiredFlag'] ?? 0,
        };
        state.proxyInfo = {
          'agentName': data['agentName'],
          'agentMobile': data['agentMobile'],
          'agentCardNo': data['agentCardNo'],
          'agentCardFrontImg': data['agentCardFrontImg'],
          'agentCardBackImg': data['agentCardBackImg'],
          'confirmationFileName': data['confirmationFileName'],
          'agentConfirmation': data['agentConfirmation']
        };
      }
      state.legalInfo = {
        'legalName': data['legalName'],
        'legalMobile': data['legalMobile'],
        'legalCardNo': data['legalCardNo'],
        'legalCardFrontImg': data['legalCardFrontImg'],
        'legalCardBackImg': data['legalCardBackImg'],
      };
      update();
    });
  }

  void goToNewEnterprise() {
    // Get.toNamed(RouteConfig.newEnterprisePage, arguments: {
    //   'basicInfo': state.basicInfo,
    //   'proxyPersonInfo': state.proxyInfo,
    //   'legalPersonInfo': state.legalInfo,
    //   'isReConfirm': true,
    // });
    Get.toNamed(RouteConfig.companyAuthGuide,
        arguments: {'authFrom': CompanyAuthFrom.update});
  }

  String baseInfoTitle() => '企业基础信息';

  String baseInfoHint() => '企业的基础信息, 营业执照';

  String proxyPersonTitle() => '企业代理人信息';

  String proxyPersonHint() => '代理人信息，身份证';

  String legalPersonTitle() => '企业法人信息';

  String legalPersonHint() => '法人信息，身份证';

  void goToHeaderNamePage() {
    Get.toNamed(RouteConfig.enterpriseHeaderAndNamePage, arguments: {
      'companyShortName': state.companyShortName,
      'companyShortNameInitials': state.companyShortNameInitials,
      'companyLogo': state.logoUrl
    })?.then((value) {
      _enterpriseInfoRequest();
    });
  }

  /// 获取认证信息
  void _requestCertificationMessage() {
    CompanyHttps.getCompanyInfo(
      getCompanyNo(),
      onSuccess: (data) {
        var status = data['realNameFlowStatus'];
        state.showBtn = status != 4;
        update();
      },
    );
  }
}
