import 'package:account_center/style/style_params.dart';
import 'package:account_center/style/widget/button_public_radius.dart';
import 'package:account_center/style/widget/my_app_bar.dart';
import 'package:flutter/material.dart';
import 'package:flutter/services.dart';
import 'package:flutter_clx_base/flutter_clx_base.dart';

import 'join_enterprise_code_logic.dart';

///加入企业 邀请码
class JoinEnterpriseCodePage extends StatelessWidget {
  final logic = Get.find<JoinEnterpriseCodeLogic>();
  final state = Get.find<JoinEnterpriseCodeLogic>().state;

  JoinEnterpriseCodePage({super.key});

  @override
  Widget build(BuildContext context) {
    return MyScaffold(
      appBar: MyAppBar('加入企业'),
      backgroundColor: Colors.white,
      body: _bodyContent(context),
    );
  }

  Widget _bodyContent(context) {
    return SingleChildScrollView(
      child: Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        mainAxisSize: MainAxisSize.min,
        children: [
          Padding(
            padding: const EdgeInsets.only(top: 30, left: 65),
            child: Text(
              '加入企业',
              style: TextStyle(
                  color: Colors.black,
                  fontWeight: FontWeight.bold,
                  fontSize: 24),
            ),
          ),
          Padding(
            padding: const EdgeInsets.only(top: 5, left: 65),
            child: Text(
              '输入企业邀请码',
              style: TextStyle(color: Color(0xffA3A8B2)),
            ),
          ),
          _textField(state.controller1, state.focusNode1),
          _itemBottomBtn(context)
        ],
      ),
    );
  }

  Widget _textField(
    TextEditingController controller,
    FocusNode focusNode,
  ) {
    return Container(
      padding: EdgeInsets.only(left: 20, right: 20),
      alignment: Alignment.center,
      margin: EdgeInsets.symmetric(horizontal: 65, vertical: 20),
      height: 55,
      color: Color(0xffF3F5F8),
      child: TextField(
        inputFormatters: [
          FilteringTextInputFormatter.allow(RegExp(r'[0-9]')) //设置只允许输入数字
        ],
        cursorColor: StyleParams.themeColor,
        textAlign: TextAlign.center,
        style: TextStyle(letterSpacing: 5, fontSize: 18),
        autofocus: true,
        maxLength: 8,
        onEditingComplete: () {},
        controller: controller,
        focusNode: focusNode,
        keyboardType: TextInputType.number,
        decoration: InputDecoration(counterText: '', border: InputBorder.none),
      ),
    );
  }

  ///底部按钮
  Widget _itemBottomBtn(context) {
    return ButtonPublicRadius(
      margin: EdgeInsets.symmetric(horizontal: 65, vertical: 50),
      onPress: () {
        logic.joinEnterprise();
      },
      text: "确定加入",
    );
  }
}
