import 'package:account_center/page/enterprise/join_or_new_enterprise_page/enterprise_see_widget.dart';
import 'package:account_center/style/widget/my_app_bar.dart';
import 'package:account_center/widget/form/form_row.dart';
import 'package:flutter/material.dart';
import 'package:flutter_clx_base/flutter_clx_base.dart';

import 'enterprise_legal_person_see_logic.dart';

///查看  企业法人信息
class EnterpriseLegalPersonSeePage extends StatelessWidget {
  final logic = Get.find<EnterpriseLegalPersonSeeLogic>();
  final state = Get.find<EnterpriseLegalPersonSeeLogic>().state;

  EnterpriseLegalPersonSeePage({super.key});

  @override
  Widget build(BuildContext context) {
    return MyScaffold(
      appBar: MyAppBar('企业法人信息'),
      body: _bodyContent(context),
    );
  }

  Widget _bodyContent(context) {
    return GetBuilder<EnterpriseLegalPersonSeeLogic>(builder: (logic) {
      return Container(
        padding: EdgeInsets.only(top: 10),
        child: SingleChildScrollView(
          child: Column(
            children: [
              EnterpriseInfoWidget.formRow('姓名', state.legalName),
              EnterpriseInfoWidget.formRow('手机号', state.legalMobile),
              EnterpriseInfoWidget.formRow('身份证号', state.legalCardNo),
              FormRow(
                title: '身份证',
                crossAxisAlignment: CrossAxisAlignment.start,
                child: Column(
                  crossAxisAlignment: CrossAxisAlignment.start,
                  children: [
                    EnterpriseInfoWidget.idImage(state.legalCardFrontImg),
                    vGap20,
                    EnterpriseInfoWidget.idImage(state.legalCardBackImg)
                  ],
                ),
              ),
            ],
          ),
        ),
      );
    });
  }
}
