import 'package:account_center/common/utils/image_load.dart';
import 'package:account_center/style/widget/my_app_bar.dart';
import 'package:flutter/material.dart';
import 'package:flutter_clx_base/flutter_clx_base.dart';

import 'enterprise_header_and_name_logic.dart';

class EnterpriseHeaderAndNamePage extends StatelessWidget {
  final logic = Get.find<EnterpriseHeaderAndNameLogic>();
  final state = Get.find<EnterpriseHeaderAndNameLogic>().state;

  final textStyleF = TextStyle(
      fontSize: 15, color: Color(0xFF344254), fontWeight: FontWeight.w500);
  final textStyleL = TextStyle(
      fontSize: 15, color: Color(0xFFA4A8B1), fontWeight: FontWeight.w500);

  final iconForward = Icon(
    Icons.arrow_forward_ios,
    color: Color(0xFFB4BAC6),
    size: 15,
  );

  EnterpriseHeaderAndNamePage({super.key});

  @override
  Widget build(BuildContext context) {
    return GetBuilder<EnterpriseHeaderAndNameLogic>(builder: (logic) {
      return MyScaffold(
        appBar: MyAppBar("账户信息"),
        children: [
          GetBuilder<EnterpriseHeaderAndNameLogic>(builder: (logic) {
            return Container(
              margin: EdgeInsets.only(top: 10),
              padding: EdgeInsets.only(left: 20, right: 20, top: 5),
              color: Colors.white,
              child: Column(
                children: [
                  InkWell(
                    onTap: () {
                      logic.cameraCapture();
                    },
                    child: SizedBox(
                      height: 60,
                      child: Row(
                        children: [
                          Expanded(
                              child: Text(
                            "企业标志",
                            style: textStyleF,
                          )),
                          ImageLoad.companyLogo(state.logoUrl,
                              width: 42, height: 42),
                          hGap5,
                          iconForward
                        ],
                      ),
                    ),
                  ),
                  InkWell(
                    onTap: () {
                      logic.goToUpdatePage('企业简称', state.companyShortName,
                          state.companyShortNameInitials);
                    },
                    child: SizedBox(
                      height: 50,
                      child: Row(
                        children: [
                          Expanded(
                            child: Text(
                              "企业简称",
                              style: textStyleF,
                            ),
                          ),
                          Text(
                            state.companyShortName ?? '',
                            style: textStyleL,
                          ),
                          hGap5,
                          iconForward
                        ],
                      ),
                    ),
                  ),
                  InkWell(
                    child: SizedBox(
                      height: 50,
                      child: Row(
                        children: [
                          Expanded(
                            child: Text(
                              "企业拼音",
                              style: textStyleF,
                            ),
                          ),
                          Text(
                              style: textStyleL,
                              state.companyShortNameInitials ?? ''),
                          hGap5,
                          iconForward
                        ],
                      ),
                    ),
                    onTap: () {
                      logic.goToUpdatePage('企业拼音', state.companyShortName,
                          state.companyShortNameInitials);
                    },
                  )
                ],
              ),
            );
          }),
        ],
      );
    });
  }
}
