import 'package:account_center/api/base_model.dart';
import 'package:account_center/common/sp/sp_util.dart';
import 'package:account_center/routes/route_config.dart';
import 'package:flutter_clx_base/flutter_clx_base.dart';

import 'enterprise_product_state.dart';

class EnterpriseProductLogic extends GetxController {
  final EnterpriseProductState state = EnterpriseProductState();

  void productListRequest(int page, int pageSize, Function success) {
    fetchList(
      Method.get,
      url: HttpApi.productCompanyList,
      queryParameters: {"companyNo": getCompanyNo()},
      onSuccess: (data) {
        success(data);
      },
      onError: (code, message) {
        success([]);
      },
    );
  }

  void goToProductDetailsPage(entity) {
    Get.toNamed(RouteConfig.productDetailsPermissionPage, arguments: {
      'entity': entity,
      'onlyShow': true,
    })?.then((value) {
      Get.back(result: {'entity': value?['entity']});
    });
  }
}
