import 'package:account_center/style/widget/button_public_radius_outline_theme.dart';
import 'package:account_center/widget/asset_image_widget.dart';
import 'package:account_center/widget/dash_line.dart';
import 'package:flutter/material.dart';

class CertificationStatusWidget extends StatelessWidget {
  final String image;
  final String title;
  final String content;
  final String buttonText;
  final Function() onClick;
  const CertificationStatusWidget({
    Key? key,
    required this.image,
    required this.title,
    required this.content,
    required this.buttonText,
    required this.onClick,
  }) : super(key: key);

  @override
  Widget build(BuildContext context) {
    return Container(
      margin: EdgeInsets.only(left: 15, top: 15, right: 15),
      decoration: BoxDecoration(
          color: Colors.white, borderRadius: BorderRadius.circular(8)),
      padding: EdgeInsets.all(30),
      child: Column(
        mainAxisSize: MainAxisSize.min,
        children: [
          _statusStyle(),
          DashLine(
            color: Color(0xffD5DBE4),
            width: 4,
          ),
          ButtonPublicRadiusOutlineTheme(
            text: buttonText,
            onPress: () {
              onClick.call();
            },
            margin: EdgeInsets.only(left: 27, right: 27, top: 20),
          ),
        ],
      ),
    );
  }

  Container _statusStyle() {
    return Container(
      padding: EdgeInsets.symmetric(horizontal: 25),
      width: double.infinity,
      decoration: BoxDecoration(
        image: DecorationImage(
            image: AssetImageWidget.getAssetImage(image),
            fit: BoxFit.fitWidth,
            alignment: Alignment.topCenter),
      ),
      child: Column(
        children: [
          SizedBox(
            height: 200,
          ),
          Text(
            title,
            style: TextStyle(
              color: Color(0xff171A1D),
              fontSize: 18,
            ),
          ),
          SizedBox(
            height: 10,
          ),
          Text(
            content,
            style: TextStyle(fontSize: 14, color: Color(0xff909399)),
          ),
          SizedBox(
            height: 20,
          )
        ],
      ),
    );
  }
}
