import 'package:account_center/style/widget/button_public_radius.dart';
import 'package:account_center/widget/dash_line.dart';
import 'package:flutter/material.dart';

class CertificationFirst extends StatelessWidget {
  final String content;
  final String buttonText;
  final Function() onClick;
  const CertificationFirst({
    Key? key,
    required this.content,
    required this.buttonText,
    required this.onClick,
  }) : super(key: key);

  @override
  Widget build(BuildContext context) {
    return Container(
      margin: EdgeInsets.only(left: 15, top: 15, right: 15),
      decoration: BoxDecoration(
          color: Colors.white, borderRadius: BorderRadius.circular(8)),
      padding: EdgeInsets.all(20),
      child: Column(
        mainAxisSize: MainAxisSize.min,
        children: [
          Container(
            padding: EdgeInsets.only(bottom: 78),
            child: Text(
              content,
              style: TextStyle(color: Color(0xff909399), fontSize: 14),
            ),
          ),
          DashLine(
            color: Color(0xffD5DBE4),
            width: 4,
          ),
          ButtonPublicRadius(
            text: buttonText,
            onPress: () {
              onClick.call();
            },
            margin: EdgeInsets.only(left: 27, right: 27, top: 20),
          ),
        ],
      ),
    );
  }
}
