import 'package:account_center/common/product_menu_control.dart';
import 'package:account_center/page/staff_manager/staff_detail/indicator_roundline.dart';
import 'package:account_center/style/style_params.dart';
import 'package:account_center/style/widget/button_public_radius.dart';
import 'package:account_center/style/widget/my_app_bar.dart';
import 'package:account_center/widget/asset_image_widget.dart';
import 'package:account_center/widget/confirm_dialog.dart';
import 'package:account_center/widget/no_data.dart';
import 'package:flutter/material.dart';
import 'package:flutter_clx_base/flutter_clx_base.dart';
import 'package:flutter_clx_base/widget/my_refresh_list_public.dart';

import 'audit_staff_logic.dart';

class AuditStaffPage extends StatelessWidget {
  final logic = Get.find<AuditStaffLogic>();
  final state = Get.find<AuditStaffLogic>().state;

  final tabTextStyle = TextStyle(
    color: Color(0xff222222),
    fontSize: 15,
    fontWeight: FontWeight.w600,
  );

  //textStyle
  final textStyle1 = TextStyle(
    color: Color(0xFF171A1D),
    fontSize: 15,
    fontWeight: FontWeight.w600,
  );
  final textStyle2 = TextStyle(
    color: Color(0xFF171A1D),
    fontSize: 12,
    fontWeight: FontWeight.w500,
  );
  final textStyle3 = TextStyle(
    color: Color(0xFF68717C),
    fontSize: 13,
    fontWeight: FontWeight.w500,
  );
  final textStyle4 = TextStyle(
    color: Color(0xFF68717C),
    fontSize: 12,
  );

  AuditStaffPage({super.key});

  @override
  Widget build(BuildContext context) {
    return MyScaffold(
      appBar: MyAppBar("新人员审核"),
      body: Column(
        children: [
          _tabBar(),
          Expanded(
            child: GetBuilder<AuditStaffLogic>(builder: (logic) {
              return _tabBarView();
            }),
          )
        ],
      ),
    );
  }

  ///tabBar
  Widget _tabBar() {
    return SizedBox(
      height: 44,
      child: Row(
        children: [
          Expanded(
            child: Container(
              color: Colors.white,
              child: TabBar(
                tabs: state.auditStatus.map((str) => Tab(text: str)).toList(),
                controller: logic.controller,
                labelStyle: tabTextStyle,
                labelColor: Color(0xff222222),
                indicatorSize: TabBarIndicatorSize.label,
                indicator: RoundLineIndicator(3.0),
                indicatorPadding: EdgeInsets.symmetric(horizontal: 12),
              ),
            ),
          ),
        ],
      ),
    );
  }

  ///tabBarView
  Widget _tabBarView() {
    return TabBarView(
        controller: logic.controller,
        children: state.auditStatus.mapIndexed((str, tabIndex) {
              return state.noData[str]
                  ? NoData()
                  : MyListViewPublic(
                      controller: logic.listController,
                      itemBuilder: (BuildContext context, int index, itemData) {
                        return _item(itemData, tabIndex);
                      },
                      requestData: (int page, int pageSize,
                          SuccessCallback success, error) {
                        logic.listLoginUserProductCompany(
                            page, pageSize, str, success, error);
                      });
            })?.toList() ??
            []);
  }

  ///列表条目
  Widget _item(itemData, int index) {
    return Container(
      margin: EdgeInsets.only(left: 10, right: 10, top: 10),
      decoration: BoxDecoration(
        color: Colors.white,
        borderRadius: BorderRadius.circular(8),
      ),
      child: Column(
        children: [
          vGap15,
          Row(
            crossAxisAlignment: CrossAxisAlignment.start,
            children: [
              hGap15,
              SizedBox(
                height: 40,
                width: 40,
                child: ImageWidget.loadNetImage(
                  itemData['applyUserImg'],
                  type: ImageTransformerType.circle,
                ),
              ),
              hGap15,
              Expanded(
                child: Column(
                  crossAxisAlignment: CrossAxisAlignment.start,
                  children: [
                    Row(
                      mainAxisAlignment: MainAxisAlignment.spaceBetween,
                      children: [
                        Text(
                          itemData['applyUserName'] ?? "",
                          style: textStyle1,
                        ),
                        Text(logic.getShowTime(itemData['createTime']),
                            style: textStyle4),
                      ],
                    ),
                    vGap5,
                    Text(
                      itemData['applyUserMobile'] ?? "",
                      style: textStyle2,
                    ),
                    vGap10,
                    Text(
                      logic.getApplyContent(itemData),
                      style: textStyle3,
                    ),
                  ],
                ),
              ),
              hGap15,
            ],
          ),
          vGap12,
          line(color: Color(0xaaE1E1E2), height: 0.5),
          index == 0
              ? _reviewButton(itemData['applyNo'])
              : _auditRecords(itemData),
        ],
      ),
    );
  }

  //审核按钮
  Widget _reviewButton(applyNo) {
    return Visibility(
      visible: hasMenuPermission('btn_handle_user_apply'),
      child: Row(
        children: [
          Expanded(
            child: TextButton(
                onPressed: () {
                  Get.dialog(_inputReasonDialog(applyNo));
                },
                child: Text(
                  "驳回",
                  style: textStyle1,
                )),
          ),
          Container(
            width: 1,
            height: 20,
            color: Color(0xFFE1E1E2),
          ),
          Expanded(
            child: TextButton(
              onPressed: () {
                ConfirmDialog(
                  content: '确定通过审核吗？',
                  confirm: () {
                    logic.auditCompanyUserAuth(20, applyNo);
                  },
                ).show();
              },
              child: Text(
                "通过",
                style: TextStyle(
                    color: StyleParams.themeColor,
                    fontSize: 15,
                    fontWeight: FontWeight.w600),
              ),
            ),
          ),
        ],
      ),
    );
  }

  //审核记录
  Widget _auditRecords(itemData) {
    return Column(
      children: [
        vGap12,
        Row(
          children: [
            hGap60,
            Expanded(
              child: Column(
                crossAxisAlignment: CrossAxisAlignment.start,
                children: [
                  Row(
                    children: [
                      SizedBox(
                        height: 20,
                        width: 20,
                        child: itemData['authUserImg'] != null
                            ? ImageWidget.loadNetImage(itemData['authUserImg'],
                                type: ImageTransformerType.circle)
                            : AssetImageWidget(
                                imgFileName: 'default_head_ic',
                              ),
                      ),
                      hGap10,
                      Text(itemData['authUserName'] ?? "-", style: textStyle2),
                      hGap5,
                      Expanded(child: _statusText(itemData['authStatus'])),
                      Text(logic.getShowTime(itemData['authTime']),
                          style: textStyle4),
                      hGap15
                    ],
                  ),
                  Offstage(
                    offstage: itemData['authContent'] == null ||
                        itemData['authContent'] == "",
                    child: Container(
                        margin: EdgeInsets.only(top: 10),
                        padding: EdgeInsets.only(
                            left: 10, top: 8, bottom: 8, right: 10),
                        decoration: BoxDecoration(
                          color: Color(0xFFF5F6FA),
                          borderRadius: BorderRadius.circular(4),
                        ),
                        child: Text(itemData['authContent'] ?? "",
                            style: textStyle4)),
                  ),
                ],
              ),
            ),
          ],
        ),
        vGap15,
      ],
    );
  }

  //输入失败原因对话框
  Widget _inputReasonDialog(applyNo) {
    return Dialog(
      child: SizedBox(
        height: 320,
        child: Column(
          children: [
            vGap20,
            Row(
              mainAxisAlignment: MainAxisAlignment.end,
              children: [
                InkWell(
                  onTap: () {
                    Get.back();
                  },
                  child: SizedBox(
                    height: 20,
                    width: 20,
                    child: Icon(
                      Icons.close,
                      color: Color(0xFFA4A8B1),
                    ),
                  ),
                ),
                hGap20,
              ],
            ),
            Text("请输入驳回原因", style: textStyle1),
            vGap15,
            Container(
              margin: EdgeInsets.only(left: 35, right: 35),
              padding: EdgeInsets.only(left: 10, right: 10, bottom: 8),
              decoration: BoxDecoration(
                  color: Color(0xFFF5F6FA),
                  borderRadius: BorderRadius.circular(8)),
              child: TextField(
                controller: logic.reasonController,
                maxLength: 50,
                maxLines: 5,
                cursorColor: StyleParams.themeColor,
                decoration: InputDecoration(
                  hintText: "选填",
                  hintStyle: textStyle4,
                  border: InputBorder.none,
                ),
              ),
            ),
            vGap15,
            ButtonPublicRadius(
                text: "确定驳回",
                onPress: () {
                  logic.auditCompanyUserAuth(30, applyNo,
                      reason: logic.reasonController.text);
                  Get.back();
                }),
          ],
        ),
      ),
    );
  }

  Widget _statusText(int status) {
    String text = "";
    switch (status) {
      case 20:
        text = "(已通过)";
        break;
      case 30:
        text = "(已驳回)";
        break;
    }
    return Text(
      text,
      style: TextStyle(
        color: status == 20 ? Color(0xFF00B444) : Color(0xFFFB7373),
        fontSize: 12,
      ),
    );
  }
}
