import 'package:account_center/account_center.dart';
import 'package:account_center/api/base_model.dart';
import 'package:account_center/common/sp/sp_util.dart';
import 'package:flutter_clx_base/widget/my_refresh_list_public.dart';

import 'widget/history_screen.dart';

class StampUseHistoryLogic extends GetxController {
  MyListController controller = MyListController();

  dynamic stampInfo;
  String? relationNoLike;
  String startTime = DateTime.now().add(Duration(days: -30)).toYMDStart;
  String endTime = DateTime.now().toYMDEnd;

  /// 签章使用记录列表获取
  void requestData(page, pageSize, success, error) {
    fetch(
      Method.post,
      url: '/msl-document/contractEvidence/pageEvidence',
      params: {
        'endTime': endTime,
        'startTime': startTime,
        'page': page,
        'pageSize': pageSize,
        'relationNoLike': relationNoLike,
        'signatureId': stampInfo?['sealId'],
        'companyNo': getCompanyNo(),
        'sealType': 2,
      },
      onSuccess: (data) {
        success(data?['records']);
      },
      onError: (code, msg) {
        error(msg);
      },
    );
  }

  /// 展示条件筛选弹窗
  void showScreenAlert() {
    Get.bottomSheet(
      HistoryScreen(
        stampInfo: stampInfo,
        serviceCode: relationNoLike,
        startTime: startTime,
        endTime: endTime,
        stampScreenBlock: _updateScreeningCondition,
      ),
      isDismissible: true,
      enableDrag: true,
      isScrollControlled: true,
    );
  }

  /// 签章使用记录筛选回调
  void _updateScreeningCondition(
      dynamic stamp, String? code, String? startTime, String? endTime) {
    stampInfo = stamp;
    relationNoLike = code;
    this.startTime = startTime ?? DateTime.now().add(Duration(days: -30)).toYMD;
    this.endTime = endTime ?? DateTime.now().toYMD;
    controller.callRefresh();
  }
}
