import 'package:account_center/account_center.dart';
import 'package:account_center/page/account_company/company_auth/widget/common/gesture_tap.dart';
import 'package:account_center/style/style_params.dart';
import 'package:flutter/material.dart';

import '../company_home/widget/company_nav.dart';
import 'stamp_manage_logic.dart';
import 'widget/stamp_item.dart';

class StampManageView extends GetView<StampManageLogic> {
  const StampManageView({super.key});

  StampManageLogic get _logic => controller;

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: CompanyManageNav.createNav('企业签章'),
      body: GetBuilder(
        init: _logic,
        builder: (controller) {
          List<Widget> list = [];
          for (var element in _logic.dataSource) {
            list.add(StampItem(item: element));
          }
          return SingleChildScrollView(
            child: Container(
              margin: EdgeInsets.only(
                  top: 10, bottom: MediaQuery.of(context).padding.bottom + 10),
              padding: const EdgeInsets.symmetric(horizontal: 20, vertical: 20),
              color: Colors.white,
              child: Wrap(
                spacing: 15,
                runSpacing: 15,
                children: list,
              ),
            ),
          );
        },
      ),
    );
  }

  Widget _actionBtn(String title, GestureTapCallback action,
      {bool isFill = false}) {
    return Expanded(
      child: GestureTapWidget(
        onTap: action,
        child: Container(
          height: 50,
          alignment: Alignment.center,
          decoration: BoxDecoration(
            borderRadius: BorderRadius.circular(8),
            border: Border.all(color: StyleParams.themeColor, width: 1),
            color: isFill ? StyleParams.themeColor : Colors.white,
          ),
          child: Text(
            title,
            style: TextStyle(
              color: !isFill ? StyleParams.themeColor : Colors.white,
              fontSize: 15,
              fontWeight: FontWeight.w600,
            ),
          ),
        ),
      ),
    );
  }
}
