import 'package:account_center/account_center.dart';
import 'package:account_center/common/product_menu_control.dart';
import 'package:account_center/common/sp/sp_key.dart';
import 'package:account_center/page/account_company/company_home/widget/warp_item.dart';
import 'package:flutter/material.dart';

class CompanyManage extends StatelessWidget {
  const CompanyManage({super.key});

  @override
  Widget build(BuildContext context) {
    return Container(
      margin: const EdgeInsets.symmetric(horizontal: 10),
      child: Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        children: [
          Padding(
            padding: const EdgeInsets.only(left: 12),
            child: Text(
              '企业管理',
              style: TextStyle(
                  color: Color(0xff222222),
                  fontSize: 15,
                  fontWeight: FontWeight.w400),
            ),
          ),
          Container(
            margin: const EdgeInsets.only(top: 10),
            constraints: BoxConstraints(minHeight: 50),
            width: double.infinity,
            decoration: BoxDecoration(
              color: Colors.white,
              borderRadius: BorderRadius.circular(8),
            ),
            child: Wrap(
              children: _companyMenus(),
            ),
          ),
        ],
      ),
    );
  }

  List<Widget> _companyMenus() {
    return []
      ..addIf(
          hasMenuPermission('menu_member_manage'),
          WarpItem(
              title: '人员管理',
              logoName: 'company_member_manage',
              tapCallback: () {
                Get.toNamed(RouteConfig.memberManagerMainPage, arguments: {
                  'companyNo': SpUtil.getString(SPKey.companyNo),
                });
              }))
      ..addIf(
        hasMenuPermission('func_staff_approve_menu'),
        WarpItem(
          title: '人员审核',
          logoName: 'company_member_audit',
          tapCallback: () {
            Get.toNamed(
              RouteConfig.auditStaffPage,
              arguments: {
                'companyNo': SpUtil.getString(SPKey.companyNo),
              },
            );
          },
        ),
      )
      ..addIf(
        hasMenuPermission('menu_position_manage'),
        WarpItem(
          title: '职位管理',
          logoName: 'company_department_tree',
          tapCallback: () {
            Get.toNamed(RouteConfig.positionManagePage);
          },
        ),
      )
      ..addIf(
        hasMenuPermission('func_role_manager'),
        WarpItem(
          title: '角色管理',
          logoName: 'company_role_manage',
          tapCallback: () {
            Get.toNamed(RouteConfig.roleManagementPage);
          },
        ),
      )
      ..addIf(
        hasMenuPermission('btn_company_product_'),
        WarpItem(
          title: '企业产品',
          logoName: 'company_product',
          tapCallback: () {
            Get.toNamed(RouteConfig.enterpriseProductPage);
          },
        ),
      );
  }
}
