import 'package:account_center/account_center.dart';
import 'package:account_center/page/account_company/company_auth/widget/common/gesture_tap.dart';
import 'package:flutter/material.dart';

class CompanyHomeItem extends StatelessWidget {
  final String title;
  final String description;
  final GestureTapCallback onTap;
  final bool canTap;

  const CompanyHomeItem({
    super.key,
    required this.title,
    this.description = '',
    required this.onTap,
    this.canTap = true,
  });

  @override
  Widget build(BuildContext context) {
    return Container(
      margin: const EdgeInsets.only(left: 10, right: 10, top: 10),
      padding: const EdgeInsets.only(left: 20, top: 20, bottom: 20, right: 15),
      decoration: BoxDecoration(
        color: Colors.white,
        borderRadius: BorderRadius.circular(8),
      ),
      child: GestureTapWidget(
        onTap: onTap,
        child: Row(
          children: [
            Text(
              title,
              style: TextStyle(
                  color: Color(0xff222222),
                  fontSize: 15,
                  fontWeight: FontWeight.w400),
            ),
            hGap10,
            Expanded(
              child: Text(
                description,
                textAlign: TextAlign.right,
                style: TextStyle(
                    color: Color(0xff88909B),
                    fontSize: 14,
                    fontWeight: FontWeight.w400),
              ),
            ),
            if (canTap) hGap5,
            if (canTap)
              Icon(
                Icons.navigate_next_rounded,
                color: Color(0xffB4BAC6),
                size: 20,
              ),
          ],
        ),
      ),
    );
  }
}
