import 'package:account_center/account_center.dart';
import 'package:account_center/common/product_menu_control.dart';
import 'package:account_center/style/style_params.dart';
import 'package:flutter/material.dart';

import 'company_manage_logic.dart';
import 'widget/authentication.dart';
import 'widget/company_home_item.dart';
import 'widget/company_info.dart';
import 'widget/company_manage.dart';

class CompanyManageView extends GetView<CompanyManageLogic> {
  const CompanyManageView({super.key});

  CompanyManageLogic get _logic => controller;

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(
        backgroundColor: StyleParams.themeColor,
        elevation: 0,
      ),
      body: GetBuilder(
          init: _logic,
          builder: ((controller) {
            return SingleChildScrollView(
              physics: ClampingScrollPhysics(),
              child: Column(
                children: [
                  /// 顶部企业信息
                  CompanyInfo(logic: _logic),

                  /// 企业认证
                  if (!_logic.isAuthenCompany) Authentication(logic: _logic),

                  /// 企业管理
                  CompanyManage(),

                  Visibility(
                    visible: hasMenuPermission('btn_enterprise_auth'),
                    child: CompanyHomeItem(
                      title: '企业认证',
                      description: _logic.companyAuth,
                      canTap: !_logic.isAuthenCompany,
                      onTap: _logic.companyAuthAction,
                    ),
                  ),

                  Visibility(
                    visible: hasMenuPermission('btn_enterprise_certification'),
                    child: CompanyHomeItem(
                      title: '企业签章',
                      description: _logic.stampStatus,
                      onTap: _logic.applyCompanyStamp,
                    ),
                  ),

                  // Visibility(
                  //   visible:
                  //       hasMenuPermission('btn_enterprise_stamp_use_history') &&
                  //           _logic.isAuthStamp,
                  //   child: CompanyHomeItem(
                  //     title: '签章使用记录',
                  //     description: '查看',
                  //     onTap: _logic.stampUseHistory,
                  //   ),
                  // ),

                  Visibility(
                    visible: hasMenuPermission('btn_invite_member'),
                    child: CompanyHomeItem(
                      title: '邀请人员',
                      onTap: _logic.inviteMemberAction,
                    ),
                  ),
                  vGap10,
                ],
              ),
            );
          })),
    );
  }
}
