import 'package:account_center/account_center.dart';
import 'package:account_center/common/sp/sp_util.dart';
import 'package:account_center/page/account_company/company_auth/widget/common/comapny_http.dart';
import 'package:account_center/page/account_company/company_auth/widget/common/company_define.dart';

class CompanyAuthResultLogic extends GetxController {
  /// 来源 sign:签章 auth:认证
  String? fromType;

  /// 当企业认证流程过来时，带有error信息以及status
  String errorMsg = '';
  AuthAndSignStatus authAndSignStatus = AuthAndSignStatus.normal;

  bool get isAuth => fromType != 'sign';
  String get title => isAuth ? '企业认证' : '企业签章';

  /// 企业认证展示数据
  String? companyName;
  String? legalName;
  String? bankNumber;

  /// 按钮文案
  String get btnTitle {
    switch (authAndSignStatus) {
      case AuthAndSignStatus.authSucc:
        return '我知道了';
      case AuthAndSignStatus.authFail:
        return '重新认证';
      case AuthAndSignStatus.signSucc:
        return '查看签章';
      case AuthAndSignStatus.signing:
      case AuthAndSignStatus.signFail:
        return '重新授权';
      default:
        return '我知道了';
    }
  }

  String get iconName {
    switch (authAndSignStatus) {
      case AuthAndSignStatus.authSucc:
      case AuthAndSignStatus.signSucc:
        return 'circle_success';
      case AuthAndSignStatus.authFail:
      case AuthAndSignStatus.signFail:
        return 'circle_failed';
      case AuthAndSignStatus.signing:
        return 'circle_normal';
      default:
        return 'circle_success';
    }
  }

  /// 结果
  String get resultString {
    switch (authAndSignStatus) {
      case AuthAndSignStatus.authSucc:
        return '恭喜您，企业认证成功';
      case AuthAndSignStatus.authFail:
        return '很抱歉，您实名认证未通过';
      case AuthAndSignStatus.signing:
        return '签署中，请耐心等待';
      case AuthAndSignStatus.signSucc:
        return '恭喜您，企业签章申请成功';
      case AuthAndSignStatus.signFail:
        return '很抱歉，您企业签章授权未通过';
      default:
        return '恭喜您，企业认证成功';
    }
  }

  @override
  void onInit() {
    fromType = Get.parameters['from'] ?? 'auth';
    errorMsg = Get.arguments?['errorMsg'] ?? '';
    authAndSignStatus = Get.arguments?['result'] ?? AuthAndSignStatus.normal;
    super.onInit();

    if (fromType == 'sign') {
      _getSignStatus();
    } else {
      _getCompanyInfo();
    }
  }

  /// 获取企业信息
  void _getCompanyInfo() {
    CompanyHttps.getCompanyRealNameTransferBankInfo(
      getCompanyNo(),
      onSuccess: (data) {
        companyName = data?['companyName'];
        legalName = data?['legalName'];
        bankNumber = data?['bankPublicNumber'];
        update();
      },
    );
  }

  /// 查看签章授权状态
  void _getSignStatus() {
    CompanyHttps.getCompanySealAuthorizationStatus(
      getCompanyNo(),
      onSuccess: (data) {
        if (data?['status'] == 0) {
          authAndSignStatus = AuthAndSignStatus.signing;
        } else if (data?['status'] == 10) {
          authAndSignStatus = AuthAndSignStatus.signSucc;
        } else if (data?['status'] == 30) {
          authAndSignStatus = AuthAndSignStatus.signFail;
          errorMsg = '授权申请已失效，请重新申请';
        }
        update();
      },
    );
  }

  void buttonAction() {
    switch (authAndSignStatus) {
      case AuthAndSignStatus.authSucc:
        Get.back();
        break;
      case AuthAndSignStatus.authFail:
        Get.offNamed(RouteConfig.companyAuth);
        break;
      case AuthAndSignStatus.signSucc:

        /// 前往签章管理
        Get.offNamed(RouteConfig.stampManage);
        break;
      case AuthAndSignStatus.signing:
      case AuthAndSignStatus.signFail:
        Get.offNamed(RouteConfig.companySign);
        break;
      default:
        break;
    }
  }
}
