import 'package:account_center/account_center.dart';
import 'package:account_center/style/style_params.dart';
import 'package:flutter/material.dart';

class GuideStep extends StatelessWidget {
  final int step;
  final String title;
  final String detail;
  final List<Widget> children;

  const GuideStep(
      {super.key,
      required this.step,
      required this.title,
      this.detail = '',
      required this.children});

  @override
  Widget build(BuildContext context) {
    return Row(
      crossAxisAlignment: CrossAxisAlignment.start,
      children: [
        Container(
          width: 24,
          height: 24,
          alignment: Alignment.center,
          decoration: BoxDecoration(
            color: StyleParams.themeColor,
            borderRadius: BorderRadius.circular(12),
          ),
          child: Text(
            step.toString(),
            style: TextStyle(
                color: Color(0xffffffff),
                fontSize: 16,
                fontWeight: FontWeight.w600),
          ),
        ),
        hGap10,
        Expanded(
          child: Column(
            crossAxisAlignment: CrossAxisAlignment.start,
            children: [
              Text(
                title,
                style: TextStyle(
                    color: Colors.black,
                    fontSize: 18,
                    fontWeight: FontWeight.w600),
              ),
              vGap10,
              Text(
                detail,
                style: TextStyle(
                    color: Color(0xff88909B),
                    fontSize: 14,
                    fontWeight: FontWeight.w400),
              ),
              ...children,
            ],
          ),
        )
      ],
    );
  }
}
