import 'package:account_center/account_center.dart';
import 'package:account_center/common/utils/image_load.dart';
import 'package:flutter/material.dart';

class GuideHeader extends StatelessWidget {
  const GuideHeader({super.key});

  @override
  Widget build(BuildContext context) {
    return Row(
      children: [
        hGap30,
        Expanded(
          child: Column(
            crossAxisAlignment: CrossAxisAlignment.start,
            children: [
              Text(
                '企业认证指南',
                style: TextStyle(
                    color: Color(0xff000000),
                    fontSize: 20,
                    fontWeight: FontWeight.w600),
              ),
              vGap10,
              Text(
                '提前准备材料，认证更顺畅',
                style: TextStyle(
                    color: Color(0xff86909C),
                    fontSize: 14,
                    fontWeight: FontWeight.w500),
              ),
            ],
          ),
        ),
        ImageLoad.loadAssertImage('company_auth_guide',
            width: 100, height: 106),
        hGap20,
      ],
    );
  }
}
