import 'package:account_center/account_center.dart';
import 'package:account_center/page/account_company/company_auth/widget/common/gesture_tap.dart';
import 'package:account_center/style/style_params.dart';
import 'package:flutter/material.dart';

import 'company_auth_guide_logic.dart';
import 'widget/guide_header.dart';
import 'widget/guide_step.dart';
import 'widget/guide_step_item.dart';

class CompanyAuthGuideView extends GetView<CompanyAuthGuideLogic> {
  const CompanyAuthGuideView({super.key});

  CompanyAuthGuideLogic get _logic => controller;

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(
        backgroundColor: StyleParams.themeColor.withOpacity(0.66),
        elevation: 0,
      ),
      body: Container(
        height: double.infinity,
        decoration: BoxDecoration(
          gradient: LinearGradient(
            colors: [
              StyleParams.themeColor.withOpacity(0.66),
              Color(0xff8CBFFE).withOpacity(0),
            ],
            begin: Alignment.topCenter,
            end: Alignment.bottomCenter,
            stops: [0.05, 0.2],
          ),
        ),
        child: SingleChildScrollView(
          physics: ClampingScrollPhysics(),
          child: Column(
            children: [
              GuideHeader(),
              Container(
                margin: const EdgeInsets.symmetric(horizontal: 10),
                padding:
                    const EdgeInsets.symmetric(horizontal: 10, vertical: 20),
                decoration: BoxDecoration(
                  color: Colors.white,
                  borderRadius: BorderRadius.circular(8),
                ),
                child: Column(
                  children: [
                    GuideStep(
                      step: 1,
                      title: '材料准备',
                      detail: '请准备真实有效的企业信息进行企业认证',
                      children: [
                        GuideStepItem(title: '营业执照', detail: '校验企业基本信息'),
                        GuideStepItem(
                            title: '法人证件', detail: '需要法人身份证正反面照片进行法人身份校验'),
                        GuideStepItem(title: '对公账户', detail: '用于对公打款验证，用于企业认证'),
                      ],
                    ),
                    vGap20,
                    GuideStep(
                      step: 2,
                      title: '打款认证',
                      detail: '我们将会打一笔款项到您的对公账户',
                      children: [
                        GuideStepItem(
                            title: '金额校验', detail: '请输入对公打款账户收到的金额，完成企业认证'),
                      ],
                    ),
                  ],
                ),
              ),
              vGap50,
              GestureTapWidget(
                onTap: _logic.gotoCompanyAuth,
                child: Container(
                  alignment: Alignment.center,
                  height: 50,
                  margin: EdgeInsets.only(
                    left: 25,
                    right: 25,
                    bottom: MediaQuery.of(context).padding.bottom + 15,
                  ),
                  decoration: BoxDecoration(
                    color: StyleParams.themeColor,
                    borderRadius: BorderRadius.circular(8),
                  ),
                  child: Text(
                    '确定',
                    style: TextStyle(
                        color: Colors.white,
                        fontSize: 15,
                        fontWeight: FontWeight.w600),
                  ),
                ),
              )
            ],
          ),
        ),
      ),
    );
  }
}
