import 'package:account_center/account_center.dart';
import 'package:flutter/material.dart';

import '../../company_auth_logic.dart';
import '../common/input_field.dart';

class DebitAccountInfo extends StatelessWidget {
  final CompanyAuthLogic logic;
  const DebitAccountInfo({super.key, required this.logic});

  @override
  Widget build(BuildContext context) {
    return Container(
      width: double.infinity,
      padding: const EdgeInsets.all(20),
      color: Colors.white,
      child: Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        children: [
          Text(
            '打款账户信息',
            style: TextStyle(
                color: Color(0xff000000),
                fontSize: 18,
                fontWeight: FontWeight.w600),
          ),
          vGap10,
          Container(
            padding: const EdgeInsets.symmetric(horizontal: 15),
            decoration: BoxDecoration(
              borderRadius: BorderRadius.circular(4),
              color: Color(0xffF3F6FA),
            ),
            child: GetBuilder(
                init: logic,
                builder: (controller) {
                  return InputField(
                    title: '开户名称',
                    value: logic.bankInfoModel.payeeName,
                    enabled: false,
                  );
                }),
          )
        ],
      ),
    );
  }
}
