import 'package:account_center/account_center.dart';
import 'package:flutter/material.dart';

import '../common/attribute_string.dart';
import '../common/company_define.dart';
import '../common/profile_upload.dart';

class LegalPersonCard extends StatelessWidget {
  final String? onUrl;
  final String? backUrl;
  final String? onError;
  final String? backError;
  final ImageUploadCallBack onCallBack;
  final ImageUploadCallBack backCallBack;
  const LegalPersonCard({
    super.key,
    required this.onCallBack,
    required this.backCallBack,
    this.onUrl,
    this.backUrl,
    this.onError,
    this.backError,
  });

  @override
  Widget build(BuildContext context) {
    return Container(
      padding: const EdgeInsets.all(20),
      color: Colors.white,
      child: Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        children: [
          CLXAttributeString()
              .add('上传', normalStyle)
              .add('法人', lightStyle)
              .add('身份证的正反面照片', normalStyle)
              .richText,
          vGap10,
          Text(
            '请确保证件边框完整、字体清晰、亮度均匀',
            style: TextStyle(
                color: Color(0xff88909B),
                fontSize: 14,
                fontWeight: FontWeight.w400),
          ),
          ProfileUpload(
            title: '头像面',
            detail: '上传身份证头像面',
            backgroundImgName: 'id_card_on_upload',
            placeholderPadding: const EdgeInsets.all(10),
            size: Size(170, 110),
            url: onUrl,
            error: onError,
            callBack: onCallBack,
          ),
          ProfileUpload(
            title: '国徽面',
            detail: '上传身份证国徽面',
            backgroundImgName: 'id_card_back_upload',
            placeholderPadding: const EdgeInsets.all(10),
            size: Size(170, 110),
            url: backUrl,
            error: backError,
            callBack: backCallBack,
          )
        ],
      ),
    );
  }
}
