import 'package:account_center/account_center.dart';
import 'package:account_center/common/utils/picker_tool.dart';
import 'package:account_center/page/account_company/company_auth/widget/common/validity_alert.dart';
import 'package:flutter/material.dart';

import '../../model/business_info_model.dart';
import '../common/attribute_string.dart';
import '../common/company_define.dart';
import '../common/input_field.dart';

class BusinessLicenseInfo extends StatelessWidget {
  final BusinessInfoModel? model;
  final InputOnChange? onChanged;
  final ValidityCallBack? confirmCallBack;
  const BusinessLicenseInfo({
    super.key,
    required this.model,
    this.onChanged,
    this.confirmCallBack,
  });

  @override
  Widget build(BuildContext context) {
    return Container(
      padding: const EdgeInsets.only(left: 20, right: 20, top: 20, bottom: 10),
      color: Colors.white,
      child: Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        children: [
          CLXAttributeString()
              .add('请确认', normalStyle)
              .add('营业执照', lightStyle)
              .add('信息', normalStyle)
              .richText,
          vGap10,
          InputField(
            title: '企业名称',
            value: model?.companyName,
            maxLength: 40,
            minLength: 2,
            onChanged: (value) {
              if (onChanged != null) {
                onChanged!(0, value);
              }
            },
          ),
          InputField(
            title: '信用代码',
            value: model?.groupCode,
            maxLength: 18,
            minLength: 18,
            onChanged: (value) {
              if (onChanged != null) {
                onChanged!(1, value);
              }
            },
          ),
          InputField(
            title: '注册资本',
            value: model?.registeredCapital,
            keyboardType: TextInputType.number,
            maxLength: 20,
            onChanged: (value) {
              if (onChanged != null) {
                onChanged!(2, value);
              }
            },
          ),
          InputField(
            title: '成立时间',
            placeholder: '请选择成立时间',
            enabled: false,
            value: model?.registrationDate,
            tapCallback: () {
              PickerTool.showDatePicker(context,
                  title: '请选择成立时间',
                  dateType: PickerDateType.YMD,
                  maxTime: DateTime.now(),
                  selectTime: model?.registrationDate?.dateTime,
                  onConfirm: (select) {
                if (onChanged != null) {
                  onChanged!(3, select.toYMD);
                }
              });
            },
          ),
          InputField(
            title: '营业期限',
            placeholder: '请选择营业期限',
            enabled: false,
            value: model?.validityTime,
            tapCallback: () {
              Get.bottomSheet(
                ValidityAlert(
                  startTime: model?.startTime,
                  endTime: model?.endTime,
                  isIndefinite: model?.isIndefinite ?? false,
                  confirmCallBack: confirmCallBack,
                ),
                isDismissible: false,
                enableDrag: false,
              );
            },
          )
        ],
      ),
    );
  }
}
