import 'package:account_center/account_center.dart';
import 'package:account_center/common/utils/image_load.dart';
import 'package:account_center/page/account_company/company_auth/widget/common/gesture_tap.dart';
import 'package:account_center/style/style_params.dart';
import 'package:account_center/widget/select_image_utils.dart';
import 'package:flutter/material.dart';

import 'company_define.dart';
import 'draw_dash_border.dart';

class ProfileUpload extends StatelessWidget {
  /// 最边距
  final EdgeInsetsGeometry margin;

  /// 内边距
  final EdgeInsetsGeometry padding;

  /// 图片与线框间距
  final EdgeInsetsGeometry placeholderPadding;

  /// 标题
  final String title;

  /// 描述
  final String detail;

  /// 占位图
  final String backgroundImgName;

  /// 上传后图片
  final String? url;

  /// 线框大小
  final Size size;

  /// 错误原因
  final String? error;

  /// 图片上传后结果回调
  final ImageUploadCallBack callBack;

  const ProfileUpload({
    super.key,
    required this.title,
    required this.detail,
    required this.backgroundImgName,
    required this.size,
    required this.callBack,
    this.error,
    this.url,
    this.margin = const EdgeInsets.only(top: 20),
    this.padding = const EdgeInsets.all(15),
    this.placeholderPadding = const EdgeInsets.all(15),
  });

  bool get showPlaceholer => getTXTString(url).isEmpty;
  bool get showError => getTXTString(error).isNotEmpty;

  @override
  Widget build(BuildContext context) {
    return Container(
      margin: margin,
      padding: padding,
      decoration: BoxDecoration(
        borderRadius: BorderRadius.circular(4),
        color: Color(0xffF3F6FA),
      ),
      child: Column(
        children: [
          Row(
            crossAxisAlignment: CrossAxisAlignment.start,
            children: [
              Expanded(
                child: Column(
                  crossAxisAlignment: CrossAxisAlignment.start,
                  children: [
                    vGap20,
                    Text(
                      title,
                      style: TextStyle(
                          color: Color(0xff000000),
                          fontSize: 16,
                          fontWeight: FontWeight.w500),
                    ),
                    vGap8,
                    Text(
                      detail,
                      style: TextStyle(
                          color: Color(0xff666666),
                          fontSize: 12,
                          fontWeight: FontWeight.w500),
                    ),
                  ],
                ),
              ),
              GestureTapWidget(
                onTap: chooseImage,
                child: Column(
                  children: [
                    DrawDashBorder(
                      width: size.width,
                      height: size.height,
                      padding: placeholderPadding,
                      decoration: BoxDecoration(
                          color: Color(0xffE9EEF7),
                          borderRadius: BorderRadius.circular(4)),
                      child: showPlaceholer
                          ? ImageLoad.loadAssertImage(backgroundImgName,
                              width: size.width -
                                  placeholderPadding.horizontal * 2,
                              height:
                                  size.height - placeholderPadding.vertical * 2)
                          : ImageLoad.loadNetImage(url,
                              width: size.width -
                                  placeholderPadding.horizontal * 2,
                              height:
                                  size.height - placeholderPadding.vertical * 2,
                              fit: BoxFit.cover),
                    ),
                    Visibility(
                      visible: !showPlaceholer,
                      child: Container(
                        padding: const EdgeInsets.symmetric(
                            vertical: 4, horizontal: 12),
                        decoration: BoxDecoration(
                          color: showError
                              ? Color(0xffFFDEDC)
                              : StyleParams.themeColor.withOpacity(0.1),
                          borderRadius: BorderRadius.circular(4),
                        ),
                        child: Row(
                          children: [
                            Icon(
                              showError
                                  ? Icons.cancel_sharp
                                  : Icons.check_circle_rounded,
                              color: showError
                                  ? Color(0xffFF3B30)
                                  : StyleParams.themeColor,
                              size: 16.5,
                            ),
                            hGap6,
                            Text(
                              '点击重新上传',
                              style: TextStyle(
                                  color: showError
                                      ? Color(0xffFF3B30)
                                      : StyleParams.themeColor,
                                  fontSize: 14,
                                  fontWeight: FontWeight.w400),
                            ),
                          ],
                        ),
                      ),
                    ),
                  ],
                ),
              )
            ],
          ),
          Visibility(
              visible: showError,
              child: Padding(
                padding: const EdgeInsets.only(top: 10),
                child: Text(
                  error ?? '',
                  style: TextStyle(
                      color: Color(0xffFF3141),
                      fontSize: 14,
                      fontWeight: FontWeight.w400),
                ),
              ))
        ],
      ),
    );
  }

  /// 选择图片&拍照
  void chooseImage() {
    selectPicType(onSuccess: callBack);
  }
}
