import 'package:account_center/api/base_model.dart';
import 'package:account_center/common/utils/format.dart';
import 'package:account_center/widget/form/form_row.dart';
import 'package:account_center/widget/form/form_show.dart';
import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';

class UserRealNameMessage extends StatefulWidget {
  final String? userNo;
  const UserRealNameMessage(this.userNo, {super.key});

  @override
  State<UserRealNameMessage> createState() => _UserRealNameMessageState();
}

class _UserRealNameMessageState extends State<UserRealNameMessage> {
  dynamic _userInfo;
  @override
  void initState() {
    _requestUserInfo();
    super.initState();
  }

  @override
  Widget build(BuildContext context) {
    return Container(
      color: CupertinoColors.white,
      width: double.infinity,
      child: Column(
        mainAxisSize: MainAxisSize.min,
        children: [
          FormShow(
            title: '姓名',
            content: Format.getEllipsisName(_userInfo?['name'] ?? ''),
          ),
          FormShow(
            title: '身份证',
            content: Format.getMidEllipsisString(_userInfo?['idCardNo'] ?? ''),
          ),
          FormShow(title: '身份证照片', content: '已上传'),
          Row(
            children: [
              Expanded(
                  child: FormShow(
                title: '有效期',
                content: (_userInfo?['cardBeginDate'] ?? '') +
                    ' 到 ' +
                    (_userInfo?['longTermFlag'] == 1
                        ? '长期'
                        : _userInfo?['cardEndDate'] ?? ''),
              )),
              Visibility(
                visible: _userInfo?['cardUpdating'] == 1,
                child: Container(
                    margin: EdgeInsets.only(right: 20),
                    color: Color(0xFF1F59EF),
                    padding: EdgeInsets.symmetric(horizontal: 5, vertical: 3),
                    child: Text(
                      '审核中',
                      style:
                          TextStyle(color: CupertinoColors.white, fontSize: 11),
                    )),
              )
            ],
          ),
          Visibility(
            visible: (_userInfo?['auditRemark'] ?? '').isNotEmpty,
            child: FormRow(
              title: '驳回原因',
              child: Text(_userInfo?['auditRemark'] ?? '',
                  style: TextStyle(
                      color: Colors.red,
                      fontSize: 16,
                      fontWeight: FontWeight.w500)),
            ),
          ),
        ],
      ),
    );
  }

  void _requestUserInfo() {
    fetch(Method.get,
        url: HttpApi.getUserRealNameInfo,
        queryParameters: {'userNo': widget.userNo}, onSuccess: (response) {
      setState(() {
        _userInfo = response;
      });
    });
  }
}
