import 'package:account_center/account_center.dart';
import 'package:account_center/common/utils/image_load.dart';
import 'package:flutter/material.dart';

import '../../../style/widget/button_public_radius.dart';

class SealPreview extends StatelessWidget {
  final String id;
  final String url;
  const SealPreview({super.key, required this.id, required this.url});

  @override
  Widget build(BuildContext context) {
    return Container(
      padding: EdgeInsets.only(left: 20, top: 10, right: 20, bottom: 20),
      decoration: BoxDecoration(borderRadius: BorderRadius.circular(10)),
      child: Column(
        crossAxisAlignment: CrossAxisAlignment.end,
        mainAxisSize: MainAxisSize.min,
        children: [
          SizedBox(
            height: 20,
          ),
          // InkWell(
          //   onTap: () {
          //     Get.back();
          //   },
          //   child: ImageLoad.loadAssertImage(
          //     'dialog_cancel',
          //     width: 20,
          //   ),
          // ),
          Container(
            padding: EdgeInsets.symmetric(horizontal: 15),
            alignment: Alignment.center,
            child: Column(
              mainAxisSize: MainAxisSize.min,
              children: [
                Text(
                  '个人签名',
                  style: TextStyle(
                    color: Color(0xFF171A1D),
                    fontSize: 18,
                  ),
                ),
                SizedBox(
                  height: 10,
                ),
                ImageLoad.loadNetImage(
                  url,
                  width: 245,
                  height: 120,
                ),
                SizedBox(height: 20),
                ButtonPublicRadius(
                  text: '关闭',
                  onPress: () {
                    Get.back();
                  },
                  margin: EdgeInsets.all(0),
                ),
              ],
            ),
          )
        ],
      ),
    );
  }
}
