import 'package:account_center/style/widget/button_public_radius.dart';
import 'package:account_center/widget/asset_image_widget.dart';
import 'package:flutter/material.dart';

class ResultLayout extends StatelessWidget {
  final String? title;
  final String? secondTitle;
  final String? buttonText;
  final String? icon;
  final void Function()? onTap;

  const ResultLayout(
      {super.key, this.title, this.secondTitle, this.buttonText,this.icon, this.onTap});

  @override
  Widget build(BuildContext context) {
    return Container(
      width: double.infinity,
      margin: EdgeInsets.only(top: 10),
      padding: EdgeInsets.symmetric(horizontal: 25, vertical: 20),
      color: Colors.white,
      child: Column(
        mainAxisSize: MainAxisSize.min,
        children: [
          AssetImageWidget(
            imgFileName: icon??'',
            width: 52,
            height: 52,
          ),
          SizedBox(height: 20),
          Text(
            title ?? '',
            style: TextStyle(
              fontSize: 17,
              color: Color(0xFF171A1D),
              fontWeight: FontWeight.w400,
            ),
          ),
          Visibility(
            visible: secondTitle?.isNotEmpty == true,
            child: Container(
              margin: EdgeInsets.only(top: 8),
              child: Text(
                secondTitle ?? '',
                style: TextStyle(
                  fontSize: 13,
                  color: Color(0xFF86909C),
                  fontWeight: FontWeight.w400,
                ),
              ),
            ),
          ),
          Visibility(
            visible: buttonText?.isNotEmpty == true,
            child: ButtonPublicRadius(
              text: buttonText ?? '',
              onPress: onTap,
              margin: EdgeInsets.only(top: 20),
            ),
          )
        ],
      ),
    );
  }
}
