import 'package:account_center/account_center.dart';
import 'package:account_center/page/account_center/account_info/account_info_logic.dart';
import 'package:account_center/page/account_center/account_info/identification_util.dart';
import 'package:account_center/page/account_center/widget/result_layout.dart';
import 'package:account_center/style/widget/button_public_radius.dart';
import 'package:account_center/style/widget/my_app_bar.dart';
import 'package:flutter/material.dart';

class IdentityFaceFail extends StatefulWidget {
  final String failReason;
  const IdentityFaceFail({super.key, required this.failReason});

  @override
  State<IdentityFaceFail> createState() => _IdentityFaceFailState();
}

class _IdentityFaceFailState extends State<IdentityFaceFail> {
  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: MyAppBar(
        '实名认证',
      ),
      body: SingleChildScrollView(
        child: Container(
          color: Colors.white,
          child: Column(
            mainAxisSize: MainAxisSize.min,
            children: [
              SizedBox(
                height: 10,
              ),
              ResultLayout(
                title: '人脸验证未通过',
                icon: 'circle_failed',
                secondTitle: widget.failReason,
              ),
              SizedBox(
                height: 10,
              ),
              ButtonPublicRadius(
                text: '重新上传',
                onPress: () {
                  Get.offNamed(RouteConfig.identityUserIdCardPage);
                },
                margin: EdgeInsets.only(top: 20, left: 20, right: 20),
              ),
              ButtonPublicRadius(
                text: '重新刷脸',
                onPress: () {
                  IdentificationUtil.startFaceVerify().then((value) {
                    if (value != null) {
                      Get.back(result: value);
                      findOtherLogic<AccountInfoLogic>()?.checkResult(value);
                    }
                  });
                },
                margin:
                    EdgeInsets.only(top: 20, left: 20, right: 20, bottom: 10),
              ),
            ],
          ),
        ),
      ),
    );
  }
}
