import 'package:account_center/common/utils/image_load.dart';
import 'package:account_center/routes/route_config.dart';
import 'package:account_center/style/widget/my_app_bar.dart';
import 'package:account_center/widget/flow_position_tag.dart';
import 'package:flutter/material.dart';
import 'package:flutter_clx_base/flutter_clx_base.dart';
import 'package:flutter_clx_base/widget/my_refresh_list_public.dart';

import 'company_manager_logic.dart';

class CompanyManagerPage extends StatelessWidget {
  final logic = Get.find<CompanyManagerLogic>();
  final state = Get.find<CompanyManagerLogic>().state;

  //颜色主
  final Color _color = const Color(0xFF171A1D);

  //字体颜色
  final Color _textColor = const Color(0xFF68717C);

  CompanyManagerPage({super.key});

  @override
  Widget build(BuildContext context) {
    return MyScaffold(
      appBar: MyAppBar("企业管理"),
      body: MyListViewPublic(
        controller: logic.listController,
        itemBuilder: (BuildContext context, int index, itemData) {
          return _buildCompanyInfoItem(itemData, index);
        },
        requestData: (int page, int pageSize, SuccessCallback success, error) {
          logic.listLoginUserProductCompany(page, pageSize, success, error);
        },
        canLoadMore: false,
      ),
    );
  }

  // 企业信息item
  Widget _buildCompanyInfoItem(itemData, int index) {
    return InkWell(
      onTap: () {
        Get.toNamed(RouteConfig.companyHome,
            arguments: {"companyNo": itemData['companyNo']});
      },
      child: Container(
        decoration: BoxDecoration(
          color: Colors.white,
          borderRadius: BorderRadius.circular(8),
        ),
        margin: const EdgeInsets.only(
          left: 10,
          right: 10,
          top: 10,
        ),
        padding: const EdgeInsets.only(
          left: 15,
          right: 15,
        ),
        height: 88,
        child: Row(
          children: [
            ImageLoad.companyLogo(itemData['companyLogo']),
            hGap10,
            Expanded(
              child: Column(
                crossAxisAlignment: CrossAxisAlignment.start,
                mainAxisAlignment: MainAxisAlignment.center,
                children: [
                  Text(
                    itemData['companyName'] ?? "",
                    style: TextStyle(
                      color: _color,
                      fontSize: 16,
                    ),
                  ),
                  SizedBox(
                    height: 4,
                  ),
                  FlowPositionTag(tags: _positionTags(itemData)),
                ],
              ),
            ),
            Icon(
              Icons.arrow_forward_ios,
              color: _textColor,
              size: 15,
            )
          ],
        ),
      ),
    );
  }

  List<String> _positionTags(itemData) {
    List<String> positions = [];
    var departments = itemData['departmentAndPositionVos'];
    if (departments is List) {
      for (var element in departments) {
        var departmentName = element['department'] ?? itemData['companyName'];
        positions.add(departmentName + '-' + element['position']);
      }
    }
    return positions;
  }
}
