import 'package:account_center/common/utils/image_load.dart';
import 'package:account_center/page/web/simple_webview.dart';
import 'package:account_center/style/style_params.dart';
import 'package:account_center/style/widget/button_public_radius.dart';
import 'package:account_center/style/widget/my_app_bar.dart';
import 'package:account_center/widget/asset_image_widget.dart';
import 'package:account_center/widget/unordered_list.dart';
import 'package:flutter/gestures.dart';
import 'package:flutter/material.dart';
import 'package:flutter_clx_base/flutter_clx_base.dart';

import 'account_cancellation_logic.dart';

class AccountCancellationPage extends StatelessWidget {
  final logic = Get.find<AccountCancellationLogic>();

  AccountCancellationPage({super.key});

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: MyAppBar('账户注销'),
      body: SingleChildScrollView(
        child: Column(
          children: [
            Container(
              margin: EdgeInsets.only(top: 10),
              padding: EdgeInsets.symmetric(horizontal: 20, vertical: 15),
              color: Colors.white,
              width: double.infinity,
              child: Column(
                children: [
                  SizedBox(height: 5),
                  AssetImageWidget(
                    imgFileName: 'circle_warning',
                    width: 52,
                    height: 52,
                  ),
                  SizedBox(height: 20),
                  Text(
                    '注销${logic.getShowPhone()}绑定的账号',
                    style: TextStyle(
                      fontSize: 17,
                      color: Color(0xFF171A1D),
                      fontWeight: FontWeight.w400,
                    ),
                  ),
                  SizedBox(height: 8),
                  UnorderedList(
                    items: [
                      '注销后，账号中留存的个人信息将被清空且无法找回',
                      '身份信息，如个人资料、实名认证信息等',
                      '账号资产及权益，如积分、优惠券等',
                      '业务订单及交易记录，请确保所有交易已完结且无纠纷，账号注销后因历史交易可能产生的资金退回等权益视为自动放弃',
                      '使用各产品时存留的其他个人信息',
                    ],
                  ),
                ],
              ),
            ),
            Container(
              margin: EdgeInsets.only(top: 10),
              padding: EdgeInsets.symmetric(horizontal: 20, vertical: 15),
              color: Colors.white,
              width: double.infinity,
              child: Column(
                children: [
                  UnorderedList(
                    items: [
                      '注销后，您将无法使用此手机号登录旗下的所有产品，包括但不限于：',
                    ],
                  ),
                  SizedBox(
                    height: 10,
                  ),
                  GetBuilder<AccountCancellationLogic>(builder: (logic) {
                    return Container(
                      alignment: Alignment.centerLeft,
                      padding: EdgeInsets.symmetric(horizontal: 5),
                      child: GridView.count(
                        shrinkWrap: true,
                        physics: NeverScrollableScrollPhysics(),
                        crossAxisCount: 5,
                        mainAxisSpacing: 5,
                        children: logic.products.map<Widget>((e) {
                          return Container(
                            padding: EdgeInsets.symmetric(horizontal: 5),
                            child: Column(
                              mainAxisSize: MainAxisSize.min,
                              children: [
                                ImageLoad.productIcon(e['productImgUrl'],
                                    width: 40, height: 40),
                                SizedBox(
                                  height: 6,
                                ),
                                Flexible(
                                  child: Text(
                                    e['productName'] ?? '',
                                    style: TextStyle(
                                        fontSize: 13, color: Color(0xFF344254)),
                                    maxLines: 1,
                                    overflow: TextOverflow.ellipsis,
                                  ),
                                )
                              ],
                            ),
                          );
                        }).toList(),
                      ),
                    );
                  })
                ],
              ),
            ),
          ],
        ),
      ),
      bottomNavigationBar: SafeArea(
        child: Container(
          margin: EdgeInsets.only(top: 5),
          padding: EdgeInsets.only(top: 5),
          color: Colors.white,
          child: Column(
            mainAxisSize: MainAxisSize.min,
            crossAxisAlignment: CrossAxisAlignment.start,
            children: [
              Container(
                margin: EdgeInsets.symmetric(horizontal: 25),
                child: RichText(
                  text: TextSpan(
                    children: [
                      const TextSpan(
                        text: '点击下方按钮代表您已同意',
                        style: TextStyle(
                          fontSize: 14,
                          color: Color(0xFF171A1D),
                        ),
                      ),
                      TextSpan(
                          text: '《公司隐私协议》',
                          style: TextStyle(
                            fontSize: 14,
                            color: StyleParams.themeColor,
                          ),
                          recognizer: TapGestureRecognizer()
                            ..onTap = () {
                              Get.to(
                                SimpleWebView(
                                    url:
                                        'https://clx-prod.oss-cn-beijing.aliyuncs.com/dispatch/agreement/DDZX_RegistrationAgreement.html',
                                    title: '用户协议'),
                              );
                            }),
                    ],
                  ),
                ),
              ),
              SizedBox(
                height: 13,
              ),
              ButtonPublicRadius(
                text: '仍要注销',
                onPress: () {
                  logic.cancellation();
                },
                margin: EdgeInsets.symmetric(horizontal: 25),
              ),
              SizedBox(
                height: 10,
              ),
            ],
          ),
        ),
      ),
    );
  }
}
