abstract class RegExpUtil {
  static String num() {
    return '[0-9]';
  }

  /// 身份证
  static String idCard() {
    return '[0-9\\X\\x]';
  }

  /// 身份证匹配
  static bool checkIdCard(String id) {
    if (id.length != 18) return false;
    var numbers = RegExp(r'(^\d{15}$)|(^\d{18}$)|(^\d{17}(\d|X|x)$)');
    return numbers.hasMatch(id);
  }

  /// 密码验证
  static bool checkPwd(String password) {
    // 检查密码长度
    if (password.length < 8 || password.length > 16) {
      return false;
    }

    // 检查是否包含大写字母
    if (!password.contains(RegExp(r'[A-Z]'))) {
      return false;
    }

    // 检查是否包含小写字母
    if (!password.contains(RegExp(r'[a-z]'))) {
      return false;
    }

    // 检查是否包含数字
    if (!password.contains(RegExp(r'[0-9]'))) {
      return false;
    }

    // 密码符合规则
    return true;
  }
}
