import 'package:account_center/page/account_company/company_auth/widget/common/gesture_tap.dart';
import 'package:account_center/style/style_params.dart';
import 'package:account_center/widget/asset_image_widget.dart';
import 'package:account_center/widget/media_preview.dart';
import 'package:flutter/material.dart';
import 'package:flutter_clx_base/flutter_clx_base.dart';
import 'package:flutter_svg/flutter_svg.dart';

import '../../api/api_config.dart';

class ImageLoad {
  static Widget user(
    String? url, {
    String? domain,
    ImageTransformerType type = ImageTransformerType.rect,
    double? width,
    double? height,
    BoxFit fit = BoxFit.cover,
  }) {
    return loadNetImage(url,
        domain: domain,
        type: type,
        width: width,
        height: height,
        fit: fit,
        defaultAssert: 'default_head_ic');
  }

  static Widget productIcon(
    String? url, {
    String? domain,
    ImageTransformerType type = ImageTransformerType.rect,
    double? width,
    double? height,
    BoxFit fit = BoxFit.cover,
  }) {
    return loadNetImage(url,
        domain: domain,
        type: type,
        width: width,
        height: height,
        fit: fit,
        defaultAssert: 'role_icon');
  }

  static Widget companyLogo(
    String? url, {
    String? domain,
    ImageTransformerType type = ImageTransformerType.rect,
    double? width = 42,
    double? height = 42,
    BoxFit fit = BoxFit.cover,
  }) {
    return Container(
      decoration: BoxDecoration(
          borderRadius: BorderRadius.circular(9),
          border: Border.all(color: Color(0xffDCDCDC), width: 0.5)),
      child: loadNetImage(url,
          domain: domain,
          type: type,
          width: width,
          height: height,
          fit: fit,
          defaultAssert: 'ic_enterprise_ph'),
    );
  }

  static Widget idCard(
    String? url, {
    String? domain,
    ImageTransformerType type = ImageTransformerType.rect,
    BoxFit fit = BoxFit.fill,
    double? width = 145,
    double? height = 90,
  }) {
    return loadNetImage(url,
        domain: domain,
        type: type,
        width: width,
        height: height,
        fit: fit,
        defaultAssert: 'ic_id_up');
  }

  static Widget licenseBusiness(
    String? url, {
    String? domain,
    ImageTransformerType type = ImageTransformerType.rect,
    BoxFit fit = BoxFit.fill,
    double? width = 145,
    double? height = 210,
  }) {
    return loadNetImage(url,
        domain: domain,
        type: type,
        width: width,
        height: height,
        fit: fit,
        defaultAssert: 'ic_id_up');
  }

  static Widget loadAssertImage(
    String name, {
    double? width,
    double? height,
  }) {
    return AssetImageWidget(
      imgFileName: name,
      width: width,
      height: height,
    );
  }

  static Widget loadNetImage(
    String? url, {
    String? domain,
    ImageTransformerType type = ImageTransformerType.rect,
    double? width,
    double? height,
    BoxFit fit = BoxFit.cover,
    String defaultAssert = 'default_head_ic',
  }) {
    Widget child;
    if (url == null || url.isEmpty) {
      child = AssetImageWidget(
        imgFileName: defaultAssert,
        width: width,
        height: height,
      );
    } else {
      child = Image.network(
        url.startsWith('http') ? url : ossDomain + url,
        width: width,
        height: height,
        fit: fit,
        errorBuilder: (content, err, stace) => AssetImageWidget(
          imgFileName: defaultAssert,
          width: width,
          height: height,
        ),
      );
    }
    return type == ImageTransformerType.rect
        ? GestureTapWidget(
            onTap: () {
              Get.to(MediaPreviewScreen(mediaList: [url], defaultIndex: 0));
            },
            child: ClipRRect(
              borderRadius: BorderRadius.circular(4),
              child: child,
            ),
          )
        : GestureTapWidget(
            onTap: () {
              Get.to(MediaPreviewScreen(mediaList: [url], defaultIndex: 0));
            },
            child: ClipOval(child: child),
          );
  }

  static Widget loadAssetsSvg(
    String name, {
    double? width,
    double? height,
    Color? color,
  }) {
    return SvgPicture.asset(
      AssetImageWidget.getSVGPath(name),
      width: width,
      height: height,
      color: color ?? StyleParams.themeColor,
      // currentColor: color ?? StyleParams.themeColor,
      colorBlendMode: BlendMode.srcIn,
    );
  }

  static Widget svgTagIcon(String name) {
    return Container(
      width: 40,
      height: 40,
      decoration: BoxDecoration(
        color: StyleParams.themeColor.withOpacity(0.2),
        borderRadius: BorderRadius.circular(6),
      ),
      alignment: Alignment.center,
      child: loadAssetsSvg(name, width: 25, height: 25),
    );
  }

  /// 角色标签
  static Widget svgTagIconByPath(String path,
      {double width = 40, double? height = 40}) {
    return Container(
      width: 40,
      height: 40,
      decoration: BoxDecoration(
        color: StyleParams.themeColor.withOpacity(0.2),
        borderRadius: BorderRadius.circular(6),
      ),
      padding: EdgeInsets.all((width - 25) / 2),
      alignment: Alignment.center,
      child: SvgPicture.string(
        path,
      ),
    );
  }
}
