import 'package:account_center/common/res/colors.dart';
import 'package:flutter/cupertino.dart';

/// 字体样式
abstract class RTextStyle {
  /// 主内容样式
  static const mainContentStyle = TextStyle(
    color: RColors.mainContentColor,
    fontSize: 15,
    fontWeight: FontWeight.w600,
  );

  /// 输入
  static const editContentStyle = TextStyle(
    color: RColors.mainContentColor,
    fontSize: 16,
    fontWeight: FontWeight.w500,
  );

  static const editHintStyle = TextStyle(
    color: RColors.hintColor,
    fontSize: 16,
    fontWeight: FontWeight.w400,
  );

  /// 职位标识字体风格
  static const positionTagStyle = TextStyle(
    color: Color(0xff76777C),
    fontSize: 12,
  );

  static const deleteButtonStyle = TextStyle(
    fontSize: 16,
    fontWeight: FontWeight.w600,
    color: Color(0xfffd5c5c),
  );
}
