import 'dart:io';

bool isAndroidVersionBelow10() {
  if (!Platform.isAndroid) {
    return false;
  }
  String version = Platform.operatingSystemVersion;
  // 提取 Android 版本号
  final RegExp versionRegex = RegExp(r'Android (\d+)');
  final match = versionRegex.firstMatch(version);
  if (match != null) {
    final androidVersion = int.tryParse(match.group(1) ?? '');
    if (androidVersion != null && androidVersion < 10) {
      return true;
    }
  }
  return false;
}
