import 'package:account_center/account_center.dart';
import 'package:account_center/common/product_menu_control.dart';
import 'package:account_center/common/sp/sp_util.dart';
import 'package:flutter/foundation.dart';

class HeaderInterceptors extends InterceptorsWrapper {
  @override
  onRequest(RequestOptions options, handler) {
    //token
    options.headers["token"] = getToken() ?? "";
    if (options.path.contains('login/loginPwd') ||
        options.path.contains('login/loginCaptcha')) {
      /// 模拟外部登录
      options.headers["product-code"] = AccountCenter.ownerProductCode;
      options.headers["version-number"] = '11';
    } else {
      options.headers["product-code"] = productCode;
    }
    options.headers["owner-product-code"] = AccountCenter.ownerProductCode;
    options.headers['client-type'] =
        defaultTargetPlatform == TargetPlatform.iOS ? 'ios' : 'android';
    // 设备唯一标识
    options.headers["device-id"] = AccountCenter.deviceInfo?.deviceId;
    // 设备名称
    options.headers["device-name"] = AccountCenter.deviceInfo?.deviceName;
    // 系统版本
    options.headers["system-version"] = AccountCenter.deviceInfo?.systemVersion;

    //todo 用户体系升级后删除
    // 设备唯一标识
    options.headers["deviceId"] = AccountCenter.deviceInfo?.deviceId;
    // 设备名称
    options.headers["deviceName"] = AccountCenter.deviceInfo?.deviceName;
    // 系统版本
    options.headers["systemVersion"] = AccountCenter.deviceInfo?.systemVersion;
    return super.onRequest(options, handler);
  }
}
