import 'package:account_center/api/base_model.dart';
import 'package:account_center/common/sp/sp_key.dart';
import 'package:account_center/common/utils/color_change.dart';
import 'package:account_center/common/utils/device_util.dart';
import 'package:account_center/routes/route_config.dart';
import 'package:account_center/style/style_params.dart';
import 'package:flutter/material.dart';
import 'package:flutter_clx_base/flutter_clx_base.dart';

import 'api/api_config.dart';

export 'package:account_center/common/utils/device_util.dart';
export 'package:flutter_clx_base/flutter_clx_base.dart';

export 'api/api_config.dart';
export 'page/account_company/company_auth/widget/common/company_extension.dart';
export 'routes/route_config.dart';

abstract class AccountCenter {
  static Future<void> init(
    UserAccountEnv e,
    String productCode, {
    String loginRouter = RouteConfig.loginPage,
  }) async {
    await preInit(e, productCode, loginRouter: loginRouter);
    await initData();
  }

  /// 预初始化，不需要调用接口，调用接口可能会获取设备信息，在用户没有同意协议之前获取会导致应用市场审核失败
  static Future<void> preInit(
    UserAccountEnv e,
    String productCode, {
    String loginRouter = RouteConfig.loginPage,
  }) async {
    env = e;
    ownerProductCode = productCode;
    AccountCenter.appScheme = appScheme;
    AccountCenter.loginRouter = loginRouter;
    ImageWidget.domain = ossDomain;
    await SpUtil.getInstance();
  }

  static Future<void> initData() async {
    refreshThemeData(ownerProductCode);
  }

  static void initUserInfo(String token) {
    SpUtil.putString(SPKey.token, token);
    fetch(Method.get, url: HttpApi.getLoginUser, onSuccess: (data) {
      SpUtil.putString(SPKey.userMobile, data['userMobile'] ?? "");
      SpUtil.putString(SPKey.userName, data['userName'] ?? "");
      SpUtil.putString(SPKey.userNo, data['userNo'] ?? "");
    });
  }

  static void initDeviceInfo() {
    getDeviceInfo().then((value) {
      deviceInfo = value;
    });
  }

  static Future<void> initDeviceInfoAsync() async {
    deviceInfo = await getDeviceInfo();
  }

  /// 设置token
  static void setToken(String? token) {
    if (token == null) {
      return;
    }
    SpUtil.putString(SPKey.token, token);
  }

  static Function()? onIdentityChange;

  /// 宿主app的产品Code
  static String ownerProductCode = '';

  static String loginRouter = RouteConfig.loginPage;

  /// H5Web页面跳转scheme，实名认知返回路径
  static String? appScheme = 'clx://$ownerProductCode';

  static refreshThemeData(String ownerProductCode) {
    fetch(Method.get, url: HttpApi.getThemeStyleByProduct, queryParameters: {
      'productCode': ownerProductCode,
    }, onSuccess: (response) {
      if (response == null) return;
      StyleParams.themeColor = hexToColor(response['themeColor']);
      StyleParams.appBarBgModel = response['titleBarColor'] ?? 1;
      StyleParams.appBarBgUrl = response['titleBarBgImg'] ?? '';
      StyleParams.buttonIsCircle = response['buttonStyle'] != 1;
      StyleParams.appBarTextColor =
          response['titleTextColor'] == 1 ? Colors.white : Colors.black;
      StyleParams.userHomeBgUrl =
          ossDomain + (response['accountCenterBgImg'] ?? '');
      StyleParams.companyHomeBgUrl =
          ossDomain + (response['companyHomeBgImg'] ?? '');
      StyleParams.userDetailBg = ossDomain + (response['empHomeBgImg'] ?? '');
      StyleParams.setCompanyCardBgColor(response['companyHomeCardColor'] ?? 1);
    }, onError: (code, msg) {});
  }

  static DeviceInfo? deviceInfo;

  static String getEsignRedirectUrl() {
    return eSignRedirectUrl;
  }
}
