import 'package:account_center/common/res/colors.dart';
import 'package:account_center/page/account_company/company_auth/widget/common/gesture_tap.dart';
import 'package:account_center/style/style_params.dart';
import 'package:account_center/widget/asset_image_widget.dart';
import 'package:flutter/material.dart';
import 'package:flutter_clx_base/flutter_clx_base.dart';
import 'package:flutter_clx_base/utils/string_util.dart';

class MySearchBar extends StatefulWidget implements PreferredSizeWidget {
  final Function(String)? onSearchClick;
  final ValueChanged<String>? onChange;
  final String? hintText;
  final Widget? leading;
  final Color? backgroundColor;
  final Color? foregroundColor;
  final bool primary;
  final Color? searchBackgroundColor;
  final Color? inputTextColor;
  final Color? hintTextColor;
  final Color? searchTextColor;
  final Function? onFocusListener;
  final String? rightText;
  final FocusNode? node;
  final bool enable;
  const MySearchBar(
      {Key? key,
      this.onSearchClick,
      this.hintText = "请输入搜索内容",
      this.leading,
      this.backgroundColor,
      this.foregroundColor,
      this.primary = true,
      this.searchBackgroundColor,
      this.inputTextColor,
      this.hintTextColor,
      this.searchTextColor,
      this.onFocusListener,
      this.rightText,
      this.node,
      this.onChange,
      this.enable = true})
      : super(key: key);

  @override
  State<MySearchBar> createState() => _MySearchBarState();

  @override
  Size get preferredSize => const Size(double.infinity, 55.0);
}

class _MySearchBarState extends State<MySearchBar> {
  final _searchInfoController = TextEditingController();
  late final FocusNode _searchFocusNode = widget.node ?? FocusNode();
  bool _isShowUserClear = false;

  @override
  void initState() {
    _searchFocusNode.addListener(() {
      _nodeListener();
    });
    super.initState();
  }

  void _nodeListener() {
    if (widget.onFocusListener != null) {
      widget.onFocusListener!(_searchFocusNode.hasFocus);
    }
    setState(() {
      _isShowUserClear =
          _searchFocusNode.hasFocus && _searchInfoController.text.isNotEmpty;
    });
  }

  @override
  Widget build(BuildContext context) {
    return Container(
      width: double.infinity,
      height: 60,
      padding: EdgeInsets.all(10),
      color: widget.backgroundColor,
      child: Row(
        children: <Widget>[
          Expanded(
            child: Container(
              decoration: BoxDecoration(
                borderRadius: const BorderRadius.all(Radius.circular(8.0)),
                color: widget.searchBackgroundColor ?? const Color(0xFFF3F4F6),
              ),
              padding: EdgeInsets.only(right: 15),
              child: Row(
                children: <Widget>[
                  hGap20,
                  AssetImageWidget(
                      imgFileName: 'ic_search', width: 20, height: 20),
                  hGap5,
                  Expanded(
                    child: TextField(
                      maxLines: 1,
                      focusNode: _searchFocusNode,
                      cursorColor: StyleParams.themeColor,
                      autofocus: false,
                      enabled: widget.enable,
                      onChanged: _valueChange,
                      style: TextStyle(
                          fontSize: 14,
                          color:
                              widget.inputTextColor ?? const Color(0xFF000000)),
                      textInputAction: TextInputAction.search,
                      controller: _searchInfoController,
                      onSubmitted: (value) => _search(),
                      decoration: InputDecoration(
                        contentPadding: const EdgeInsets.symmetric(
                            horizontal: 0.0, vertical: 8.0),
                        isDense: true,
                        counterText: "",
                        hintText: widget.hintText,
                        hintStyle: TextStyle(
                            fontSize: 14.0,
                            color: widget.hintTextColor ??
                                const Color(0xFF999999)),
                        border: InputBorder.none, //去掉下划线
                        suffixIcon: _isShowUserClear
                            ? GestureTapWidget(
                                child: Icon(
                                  Icons.clear,
                                  color: RColors.appMain,
                                ),
                                onTap: () {
                                  // 清空输入框内容
                                  _searchInfoController.clear();

                                  _valueChange('');
                                },
                              )
                            : null,
                        suffixIconConstraints:
                            BoxConstraints(maxWidth: 14, maxHeight: 14),

                        //hintStyle: TextStyles.textGrayC14
                      ),
                    ),
                  ),
                ],
              ),
            ),
          ),
        ],
      ),
    );
  }

  void _valueChange(value) {
    widget.onChange?.call(value);
    _nodeListener();
  }

  /// 搜索
  void _search() {
    KeyBoardUtils.hideKeyboard();
    if (widget.onSearchClick != null) {
      widget.onSearchClick!(getControllerString(_searchInfoController));
    }
  }
}
