import 'package:account_center/common/res/colors.dart';
import 'package:account_center/common/res/text_style.dart';
import 'package:account_center/page/account_company/company_auth/widget/common/gesture_tap.dart';
import 'package:account_center/style/style_params.dart';
import 'package:flutter/material.dart';
import 'package:flutter/services.dart';
import 'package:flutter_clx_base/flutter_clx_base.dart';

/// 表单无样式的输入框
class FormEditClear extends StatefulWidget {
  final TextEditingController controller;
  final String hint; //提示文字
  final ValueChanged<String>? changed; // 输入变化
  final FocusNode focusNode; //监听器
  final int maxLength; //最大输入长度
  final String? regExp; //正则表达式规则
  final TextInputType inputType; //输入类型
  final bool enabled;
  final String? Function()? getErrText;

  const FormEditClear({
    Key? key,
    required this.focusNode,
    required this.controller,
    this.hint = '请输入',
    this.changed,
    this.maxLength = 11,
    this.regExp,
    this.inputType = TextInputType.text,
    this.enabled = true,
    this.getErrText,
  }) : super(key: key);

  @override
  State<FormEditClear> createState() => _FormEditClearState();
}

class _FormEditClearState extends State<FormEditClear> {
  bool _isShowUserClear = false;

  // 监听焦点
  _focusNodeListener() {
    setState(() {
      _isShowUserClear =
          widget.focusNode.hasFocus && widget.controller.text.isNotEmpty;
    });
  }

  @override
  void dispose() {
    widget.focusNode.removeListener(_focusNodeListener);
    super.dispose();
  }

  @override
  void initState() {
    super.initState();
    widget.focusNode.addListener(_focusNodeListener);
  }

  /// 数据变化
  _valueChange(String value) {
    setState(() {
      _isShowUserClear = value.isNotEmpty && widget.focusNode.hasFocus;
    });
    widget.changed?.call(value);
  }

  @override
  Widget build(BuildContext context) {
    return TextField(
      controller: widget.controller,
      keyboardType: widget.inputType,
      onChanged: _valueChange,
      focusNode: widget.focusNode,
      cursorColor: StyleParams.themeColor,
      maxLines: null,
      style: widget.enabled
          ? RTextStyle.editContentStyle
          : RTextStyle.editHintStyle,
      enabled: widget.enabled,
      decoration: InputDecoration(
          hintText: widget.hint,
          hintStyle: RTextStyle.editHintStyle,
          isDense: true,
          contentPadding: const EdgeInsets.all(0),
          border: InputBorder.none,
          suffixIcon: _isShowUserClear
              ? GestureTapWidget(
                  child: Icon(
                    Icons.clear,
                    color: RColors.appMain,
                  ),
                  onTap: () {
                    // 清空输入框内容
                    widget.controller.clear();
                    _valueChange('');
                  },
                )
              : null,
          suffixIconConstraints: BoxConstraints(maxWidth: 14, maxHeight: 14),
          errorText: widget.getErrText?.call()),
      inputFormatters: [
        LengthLimitingTextInputFormatter(widget.maxLength),
      ]..addIf(
          widget.regExp != null,
          FilteringTextInputFormatter.allow(
            RegExp(widget.regExp ?? ''),
          ),
        ),
    );
  }
}
