import 'package:account_center/page/account_company/company_auth/widget/common/gesture_tap.dart';
import 'package:account_center/style/style_params.dart';
import 'package:flutter/material.dart';
import 'package:flutter_clx_base/flutter_clx_base.dart';

class ConfirmDialogAsync extends StatelessWidget {
  final String content;
  final String rightText;
  final String leftText;
  final Function()? rightTap;
  final Function()? leftTap;
  const ConfirmDialogAsync({
    super.key,
    required this.content,
    this.rightText = '确定',
    this.leftText = '取消',
    this.rightTap,
    this.leftTap,
  });

  Future show({barrierDismissible = true}) {
    return Get.dialog(this,
        useSafeArea: true, barrierDismissible: barrierDismissible);
  }

  @override
  Widget build(BuildContext context) {
    return Dialog(
      child: Container(
        width: 270,
        decoration: BoxDecoration(
          color: Colors.white,
          borderRadius: BorderRadius.circular(7),
        ),
        child: Column(
          mainAxisSize: MainAxisSize.min,
          children: [
            ConstrainedBox(
              constraints: BoxConstraints(
                minHeight: 85,
              ),
              child: Container(
                alignment: Alignment.center,
                padding: EdgeInsets.symmetric(horizontal: 15, vertical: 10),
                child: Text(
                  content,
                  style: TextStyle(
                    color: Color(0xFF888888),
                    fontSize: 15,
                    fontWeight: FontWeight.w500,
                  ),
                ),
              ),
            ),
            Container(
              color: Color(0xFFDCDEE3),
              height: 0.5,
            ),
            Row(
              children: [
                Expanded(
                  child: GestureTapWidget(
                    onTap: leftTap ??
                        () {
                          Get.back();
                        },
                    child: Container(
                      height: 50,
                      color: Colors.transparent,
                      alignment: Alignment.center,
                      child: Text(
                        leftText,
                        style: TextStyle(
                          color: Colors.black,
                          fontSize: 18,
                        ),
                      ),
                    ),
                  ),
                ),
                Container(
                  width: 0.5,
                  color: Color(0xFFDCDEE3),
                  height: 50,
                ),
                Expanded(
                  child: GestureTapWidget(
                    onTap: rightTap ??
                        () {
                          Get.back(result: true);
                        },
                    child: Container(
                      alignment: Alignment.center,
                      color: Colors.transparent,
                      height: 50,
                      child: Text(
                        rightText,
                        style: TextStyle(
                          color: StyleParams.themeColor,
                          fontSize: 18,
                        ),
                      ),
                    ),
                  ),
                )
              ],
            )
          ],
        ),
      ),
    );
  }
}
