import 'package:account_center/account_center.dart';
import 'package:account_center/style/style_params.dart';
import 'package:flutter/material.dart';

/// 编辑状态先appbar
class EditAppBar extends StatelessWidget implements PreferredSizeWidget {
  final String? title;
  final void Function()? confirm;
  final void Function()? cancel;
  final double? elevation;
  final bool showConfirm;
  final bool showCancel;
  final String confirmText;
  final bool hideBackArrow;

  const EditAppBar({
    Key? key,
    this.title,
    this.confirm,
    this.elevation,
    this.cancel,
    this.showConfirm = true,
    this.showCancel = true,
    this.confirmText = '完成',
    this.hideBackArrow = false,
  }) : super(key: key);

  @override
  Widget build(BuildContext context) {
    var titleColor = StyleParams.appBarTextColor;
    return AppBar(
      key: key,
      flexibleSpace: Container(
        decoration: StyleParams.appBarBgModel == 3
            ? BoxDecoration(
                image: DecorationImage(
                  image: NetworkImage(ossDomain + StyleParams.appBarBgUrl),
                  fit: BoxFit.cover,
                ),
              )
            : null,
      ),
      backgroundColor: StyleParams.getAppBarBgColor(),
      elevation: elevation,
      centerTitle: true,
      title: Text(
        title ?? '',
        style: TextStyle(color: StyleParams.appBarTextColor),
      ),
      leading: showCancel
          ? TextButton(
              onPressed: cancel ?? () => Get.back(),
              child: Text(
                '取消',
                style: TextStyle(color: titleColor),
              ),
            )
          : null,
      actions: [
        Visibility(
          visible: showConfirm,
          child: TextButton(
            onPressed: confirm,
            child: Text(
              confirmText,
              style: TextStyle(color: titleColor),
            ),
          ),
        ),
      ],
      automaticallyImplyLeading: !hideBackArrow,
    );
  }

  @override
  Size get preferredSize => const Size(double.infinity, 55);
}
