import 'package:account_center/common/res/colors.dart';
import 'package:account_center/page/account_company/company_auth/widget/common/gesture_tap.dart';
import 'package:flutter/material.dart';

class ButtonDelete extends StatelessWidget {
  final String title;
  final void Function()? onTap;
  const ButtonDelete({Key? key, required this.title, this.onTap})
      : super(key: key);

  @override
  Widget build(BuildContext context) {
    return GestureTapWidget(
      onTap: onTap,
      child: Container(
        color: Colors.white,
        height: 55,
        width: double.infinity,
        alignment: Alignment.center,
        child: Text(
          title,
          style: TextStyle(
              color: RColors.deleteColor,
              fontSize: 16,
              fontWeight: FontWeight.w500),
        ),
      ),
    );
  }
}
