import 'package:account_center/account_center.dart';
import 'package:account_center/style/style_params.dart';
import 'package:account_center/widget/radio_check.dart';
import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';

/// 风格化控件，处理统一风格,和颜色
abstract class StyleWidget {
  /// 开关按钮
  static Widget switchButton(bool value, ValueChanged<bool>? onChanged) {
    return CupertinoSwitch(
      value: value,
      onChanged: onChanged,
      activeColor: StyleParams.themeColor,
    );
  }

  static Widget itemRadio(
    value,
    groupValue,
    String text,
    void Function(dynamic value) onChange, {
    bool forbid = false,
  }) {
    return RadioCheck(
      title: text,
      value: value,
      groupValue: groupValue,
      change: onChange,
      isForbid: forbid,
    );
  }

  static Widget checkBox(bool checked, Function(bool value) onChange,
      {bool forbid = false}) {
    return GFCheckbox(
        size: 22,
        type: GFCheckboxType.circle,
        value: checked,
        activeBgColor: forbid ? Color(0xFFF5F7FA) : StyleParams.themeColor,
        inactiveBorderColor: Color(0xFFCCCCCC),
        activeIcon: Icon(
          Icons.check,
          size: 14,
          color: forbid ? Color(0xFFA9ABAC) : GFColors.WHITE,
        ),
        onChanged: (checked) {
          if (!forbid) {
            onChange(checked);
          }
        });
  }

  static Widget itemSwitch(
    bool value,
    ValueChanged<bool>? onChanged,
    String text, {
    bool forbid = false,
  }) {
    return Row(
      children: [
        Expanded(
            child: Text(
          text,
          style: TextStyle(
              fontSize: 15,
              color: Color(0xFF344254),
              fontWeight: FontWeight.w500),
        )),
        switchButton(value, onChanged),
      ],
    );
  }

  static Widget textButton(String name, void Function()? onPressed) {
    return TextButton(
      onPressed: onPressed,
      child: Text(
        name,
        style: TextStyle(color: StyleParams.themeColor),
      ),
    );
  }

  static Widget bottomButtonRow(List<Widget> children) {
    return Container(
      padding: EdgeInsets.only(bottom: 15),
      decoration: BoxDecoration(boxShadow: const [
        BoxShadow(
          color: Color(0x05000000),
          offset: Offset(1, -2),
        )
      ], color: Colors.white),
      child: Row(
        children: children,
      ),
    );
  }
}
