import 'package:account_center/account_center.dart';
import 'package:account_center/common/product_menu_control.dart';
import 'package:account_center/common/res/colors.dart';
import 'package:account_center/common/res/text_style.dart';
import 'package:account_center/page/account_company/company_auth/widget/common/gesture_tap.dart';
import 'package:account_center/page/staff_manager/model/staff_model.dart';
import 'package:account_center/page/staff_manager/model/staff_model_util.dart';
import 'package:account_center/page/staff_manager/staff_manager_main/staff_manager_main_logic.dart';
import 'package:account_center/style/widget/button_public_radius.dart';
import 'package:account_center/style/widget/my_app_bar.dart';
import 'package:account_center/widget/asset_image_widget.dart';
import 'package:account_center/widget/flow_position_tag.dart';
import 'package:account_center/widget/search_bar.dart' as search_bar;
import 'package:flutter/material.dart';
import 'package:flutter_clx_base/widget/my_refresh_list_public.dart';

class StaffManagerMainPage extends StatelessWidget {
  StaffManagerMainPage({super.key});

  final logic = Get.find<StaffManagerMainLogic>();
  final state = Get.find<StaffManagerMainLogic>().state;

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: MyAppBar(
        '人员管理',
      ),
      resizeToAvoidBottomInset: false,
      body: GetBuilder<StaffManagerMainLogic>(builder: (s) {
        return Column(
          children: [
            search_bar.MySearchBar(
              backgroundColor: Colors.white,
              hintText: '搜索',
              onSearchClick: logic.search,
              onChange: logic.searchKeyChange,
            ),
            vGap10,
            Expanded(
              child: MyListViewPublic(
                firstRefresh: true,
                pageSize: 20,
                controller: logic.userListController,
                itemBuilder: (context, index, data) {
                  return mackItem(StaffModel.fromJson(data));
                },
                requestData: (int page, int pageSize, success, error) {
                  logic.getItemList(page, pageSize, success, error);
                },
              ),
            ),
            Visibility(
              visible: hasMenuPermission('btn_new_member'),
              child: Container(
                color: Colors.white,
                padding: EdgeInsets.only(top: 8, bottom: 20),
                child: ButtonPublicRadius(
                  onPress: () {
                    Get.toNamed(RouteConfig.staffAddPage);
                  },
                  text: '新建人员',
                ),
              ),
            ),
          ],
        );
      }),
    );
  }

  Widget mackItem(StaffModel staff) {
    return GestureTapWidget(
      onTap: () {
        logic.toStaffDetail(staff);
      },
      child: Column(
        children: [
          Container(
            color: Colors.white,
            padding: EdgeInsets.symmetric(horizontal: 15),
            child: Column(
              children: [
                vGap15,
                Row(
                  children: [
                    SizedBox(
                      height: 42,
                      width: 42,
                      child: staff.headImg?.isNotEmpty == true
                          ? ImageWidget.loadNetImage(staff.headImg,
                              type: ImageTransformerType.circle)
                          : AssetImageWidget(
                              imgFileName: 'default_head_ic',
                            ),
                    ),
                    hGap15,
                    Column(
                      crossAxisAlignment: CrossAxisAlignment.start,
                      children: [
                        Text(
                          staff.userName ?? '',
                          style: RTextStyle.mainContentStyle,
                        ),
                        vGap4,
                        Text(
                          staff.userMobile ?? '',
                          style: TextStyle(
                            color: RColors.hintColor,
                            fontSize: 12,
                          ),
                        ),
                      ],
                    )
                  ],
                ),
                Visibility(
                    visible: staff.getPositions().isNotEmpty,
                    child: Column(
                      children: [
                        vGap5,
                        Container(
                          margin: EdgeInsets.only(left: 60),
                          child: Row(
                            children: [
                              Expanded(
                                child:
                                    FlowPositionTag(tags: staff.getPositions()),
                              )
                            ],
                          ),
                        ),
                      ],
                    )),
                vGap15,
                Divider(
                  height: 0.5,
                  color: Color(0xffe1e1e2),
                )
              ],
            ),
          ),
        ],
      ),
    );
  }
}
