import 'package:account_center/account_center.dart';
import 'package:account_center/common/res/text_style.dart';
import 'package:account_center/common/utils/image_load.dart';
import 'package:account_center/page/account_company/company_auth/widget/common/gesture_tap.dart';
import 'package:account_center/page/staff_manager/staff_detail/staff_detail_logic.dart';
import 'package:account_center/style/svg_path.dart';
import 'package:account_center/widget/no_data.dart';
import 'package:flutter/material.dart';

class RoleDetail extends StatelessWidget {
  RoleDetail({Key? key}) : super(key: key);

  final logic = Get.find<StaffDetailLogic>();

  @override
  Widget build(BuildContext context) {
    return GetBuilder<StaffDetailLogic>(
        id: logic.keyRoleList,
        builder: (s) {
          return logic.roleList.isNotEmpty
              ? ListView.builder(
                  padding: EdgeInsets.zero,
                  itemBuilder: (context, index) {
                    var role = logic.roleList.getElement(index);
                    return GestureTapWidget(
                      onTap: () {
                        logic.toRoleDetail(role);
                      },
                      child: Container(
                        height: 60,
                        margin:
                            EdgeInsets.only(left: 10, right: 10, bottom: 10),
                        padding: EdgeInsets.symmetric(horizontal: 15),
                        decoration: BoxDecoration(
                          color: Colors.white,
                          borderRadius: BorderRadius.circular(8),
                        ),
                        child: Row(
                          children: [
                            ImageLoad.svgTagIconByPath(SvgPath.roleIcon()),
                            hGap15,
                            Expanded(
                              child: Text(
                                role['roleName'],
                                style: RTextStyle.mainContentStyle,
                              ),
                            ),
                            Icon(
                              Icons.arrow_forward_ios,
                              color: Color(0xffB4BAC6),
                              size: 20,
                            )
                          ],
                        ),
                      ),
                    );
                  },
                  itemCount: logic.roleList.length,
                )
              : NoData();
        });
  }
}
