import 'package:account_center/api/base_model.dart';
import 'package:account_center/common/sp/sp_key.dart';
import 'package:account_center/page/staff_manager/staff_manager_main/staff_manager_main_logic.dart';
import 'package:flutter_clx_base/flutter_clx_base.dart';

import '../../../routes/route_config.dart';
import 'staff_add_state.dart';

class StaffAddLogic extends GetxController {
  final StaffAddState state = StaffAddState();
  final String companyName = '';

  final Map baseParams = {
    "companyName": SpUtil.getString(SPKey.companyName),
    "companyNo": SpUtil.getString(SPKey.companyNo),
    "operationUserNo": SpUtil.getString(SPKey.userNo),
    // "productCode": SpUtil.getString(SPKey.productCode),
  };

  /// 验证码状态
  void setVerify(bool? value) {
    state.isVerify = value == true;
    update();
  }

  /// 提交
  submit() {
    if (!checkData()) {
      KeyBoardUtils.hideKeyboard();
      return;
    }
    LoadingUtils.showLoading(text: '');
    fetch(
      Method.post,
      url: HttpApi.addCompanyUser,
      params: getRequestParams(),
      onSuccess: (response) {
        LoadingUtils.dismiss();
        ToastUtil.showToast('添加成功');
        findOtherLogic<StaffManagerMainLogic>()
            ?.userListController
            .callRefresh();
        Get.offNamed(RouteConfig.editPeoplePage, arguments: {
          'userNo': response,
        });
      },
      onError: (code, msg) {
        LoadingUtils.dismiss();
      },
    );
  }

  /// 请求数据
  Map<dynamic, dynamic> getRequestParams() {
    var params = {...baseParams};
    params['userMobile'] = state.phoneController.text;
    params['userName'] = state.nameController.text;
    if (state.isVerify) {
      params['verificationCode'] = state.codeController.text;
    }
    return params;
  }

  /// 验证数据合法性
  bool checkData() {
    if (state.phoneController.text.length != 11) {
      ToastUtil.showToast('请输入正确的电话号码');
      return false;
    }

    if (state.nameController.text.isEmpty) {
      ToastUtil.showToast('请输入人员名称');
      return false;
    }

    if (state.isVerify && state.codeController.text.length != 6) {
      ToastUtil.showToast('请输入正确的验证码');
      return false;
    }

    return true;
  }

  verifyChange(bool? check) {
    state.isVerify = check == true;
    update();
  }

  void onPhoneNumberInput(value) {
    if (value.toString().length == 11) {
      fetch(
        Method.get,
        url: HttpApi.getCommonUserByMobile,
        queryParameters: {'mobile': value},
        onSuccess: (response) {
          if (response != null) {
            state.nameController.text = response['userName'] ?? '';
            state.enabledName = false;
          } else {
            state.enabledName = true;
            state.nameController.text = '';
          }
          update();
        },
        onError: (code, message) {
          ToastUtil.showToast(message.toString());
        },
      );
    } else {
      state.enabledName = true;
      state.nameController.text = '';
      update();
    }
  }
}
