import 'package:account_center/api/base_model.dart';
import 'package:account_center/routes/route_config.dart';
import 'package:flutter_clx_base/flutter_clx_base.dart';

class PositionDetailLogic extends GetxController {
  List<dynamic> personList = [];

  var positionName = '';
  dynamic data;
  @override
  void onInit() {
    data = Get.arguments;
    positionName = data?['positionName'] ?? '';
    _requestPersonList();
    super.onInit();
  }

  void editPosition() {
    Get.toNamed(RouteConfig.editOrNewPositionPage, arguments: data)
        ?.then((value) {
      if (value != null) {
        if (value == 'delete') {
          Get.back(result: {});
        } else {
          _requestPersonList();
        }
      }
    });
  }

  void _requestPersonList() {
    fetch(Method.get, url: HttpApi.getPositionWithUsers, queryParameters: {
      'positionNo': data?['positionNo'],
    }, onSuccess: (response) {
      personList = response['users'] ?? [];
      positionName = response['positionName'] ?? '';
      data['positionName'] = positionName;
      update();
    }, onError: (code, msg) {});
  }
}
