import 'package:account_center/common/product_menu_control.dart';
import 'package:account_center/common/res/colors.dart';
import 'package:account_center/common/utils/image_load.dart';
import 'package:account_center/style/widget/bottom_buttons.dart';
import 'package:account_center/style/widget/edit_app_bar.dart';
import 'package:account_center/style/widget/my_app_bar.dart';
import 'package:account_center/widget/form/form_input.dart';
import 'package:flutter/material.dart';
import 'package:flutter_clx_base/flutter_clx_base.dart';

import 'edit_or_new_position_logic.dart';

class EditOrNewPositionPage extends StatelessWidget {
  final logic = Get.find<EditOrNewPositionLogic>();

  EditOrNewPositionPage({super.key});

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: (!logic.isEdit || _canEdit()
          ? EditAppBar(
              title: logic.title,
              confirm: logic.confirm,
            )
          : MyAppBar('职位详情')) as PreferredSizeWidget?,
      body: GetBuilder<EditOrNewPositionLogic>(builder: (logic) {
        return CustomScrollView(
          slivers: [
            SliverToBoxAdapter(
              child: Column(
                children: [
                  _inputName(),
                  SizedBox(
                    height: 10,
                  ),
                  Container(
                    padding: EdgeInsets.symmetric(horizontal: 20, vertical: 15),
                    color: Colors.white,
                    child: Row(
                      children: [
                        Expanded(
                            child: Text(
                          "职位人员（${logic.personList.length}）",
                          style: TextStyle(
                              fontSize: 16, fontWeight: FontWeight.bold),
                        )),
                      ],
                    ),
                  ),
                  SizedBox(
                    height: 1,
                  ),
                  Container(
                    padding: EdgeInsets.symmetric(horizontal: 10, vertical: 15),
                    alignment: Alignment.topLeft,
                    child: InkWell(
                      onTap: () {
                        logic.goToPersonListPage();
                      },
                      child: Row(
                        children: [
                          Icon(
                            Icons.add,
                            color: RColors.mainContentColor,
                          ),
                          hGap5,
                          Expanded(
                              child: Text(
                            "添加人员",
                            style: TextStyle(
                                color: RColors.mainContentColor,
                                fontWeight: FontWeight.w500),
                          ))
                        ],
                      ),
                    ),
                  ),
                  SizedBox(
                    height: 1,
                  )
                ],
              ),
            ),
            SliverFixedExtentList(
                delegate: SliverChildBuilderDelegate((context, index) {
                  return _itemViewPro(logic.personList.getElement(index));
                }, childCount: logic.personList.length),
                itemExtent: 70),
          ],
        );
      }),
      bottomNavigationBar: Visibility(
        visible: logic.isEdit && _canEdit(),
        child: BottomButtons(
          items: [
            ButtonItem(
                title: '删除职位',
                onClick: () {
                  logic.deletePosition();
                },
                isDelete: true),
          ],
        ),
      ),
    );
  }

  Widget _itemViewPro(item) {
    return Container(
      margin: EdgeInsets.only(bottom: 1),
      padding: EdgeInsets.symmetric(horizontal: 20, vertical: 10),
      color: Colors.white,
      child: Row(
        children: [
          InkWell(
            onTap: () {
              logic.deletePerson(item);
            },
            child: Icon(
              Icons.remove_circle_outlined,
              color: Colors.red,
            ),
          ),
          SizedBox(
            width: 10,
          ),
          ImageLoad.user(item['headImg'],
              width: 50, height: 50, type: ImageTransformerType.circle),
          hGap15,
          Expanded(
              child: Text(
            item['userName'] ?? '',
            style: TextStyle(fontSize: 16, fontWeight: FontWeight.bold),
          )),
        ],
      ),
    );
  }

  ///职位名称
  Widget _inputName() {
    return FormInput(
      title: '职位名称',
      controller: logic.controller,
      focusNode: logic.focusNode,
      maxLength: 10,
      isRequired: true,
      check: logic.showErr,
      enabled: !logic.isEdit || _canEdit(),
    );
  }

  bool _canEdit() => hasMenuPermission('func_edit_position');
}
