import 'package:account_center/common/product_menu_control.dart';
import 'package:account_center/common/res/colors.dart';
import 'package:account_center/common/res/text_style.dart';
import 'package:account_center/style/style_widget.dart';
import 'package:account_center/style/widget/edit_app_bar.dart';
import 'package:account_center/widget/confirm_dialog.dart';
import 'package:account_center/widget/form/form_input.dart';
import 'package:account_center/widget/form/form_row.dart';
import 'package:flutter/material.dart';
import 'package:flutter_clx_base/flutter_clx_base.dart';

import 'role_setting_logic.dart';

///角色设置
class RoleSettingPage extends StatelessWidget {
  final logic = Get.find<RoleSettingLogic>();
  final state = Get.find<RoleSettingLogic>().state;

  RoleSettingPage({super.key});

  @override
  Widget build(BuildContext context) {
    return MyScaffold(
      appBar: EditAppBar(
        title: "编辑角色",
        confirm: () {
          logic.updateRoleRequest();
        },
        cancel: () {
          logic.back();
        },
        showCancel: false,
        showConfirm: hasMenuPermission('btn_update_role'),
      ),
      body: _bodyContent(),
    );
  }

  Widget _bodyContent() {
    return GetBuilder<RoleSettingLogic>(builder: (logic) {
      return Container(
        margin: EdgeInsets.only(top: 10),
        child: SingleChildScrollView(
          child: Column(
            crossAxisAlignment: CrossAxisAlignment.start,
            children: [
              Container(
                color: Colors.white,
                child: Column(
                  mainAxisAlignment: MainAxisAlignment.start,
                  children: [
                    FormInput(
                      title: '角色名称',
                      controller: state.controllerName,
                      focusNode: FocusNode(),
                      maxLength: 20,
                    ),
                    itemStrategy(
                      onChanged: (value) {
                        logic.radioChange(value);
                      },
                    ),
                    FormInput(
                      title: '描述',
                      controller: state.controllerDescribe,
                      focusNode: FocusNode(),
                      maxLength: 200,
                    ),
                    itemBottomSwitch()
                  ],
                ),
              ),
              _deleteBtn(),
            ],
          ),
        ),
      );
    });
  }

  Widget _itemTop(
      String title, String value, TextEditingController editingController,
      {int maxLength = 20}) {
    return Row(
      children: [
        SizedBox(
          width: 70,
          child: Text(
            title,
            style: TextStyle(fontSize: 16.0, fontWeight: FontWeight.w500),
          ),
        ),
        hGap20,
        Expanded(
            child: TextField(
          controller: editingController,
          style: TextStyle(color: Colors.black, fontSize: 16.0),
          decoration: InputDecoration(
            counterText: "",
            border: InputBorder.none,
            hintStyle: TextStyle(color: RColors.hintColor),
            hintText: '请输入',
          ),
        )),
      ],
    );
  }

  ///角色策略
  Widget itemStrategy({required ValueChanged<int?> onChanged}) {
    return FormRow(
      crossAxisAlignment: CrossAxisAlignment.start,
      vCap: 8,
      title: "角色策略",
      child: Wrap(
        runSpacing: 4,
        spacing: 20,
        children: [
          _itemRadio("无策略", 0, onChanged: onChanged),
          _radioSecondTitle('角色默认无任何权限'),
          SizedBox(
            height: 4,
          ),
          // _itemRadio("所有权限", 1, onChanged: onChanged),
          // _radioSecondTitle('角色默认具有所有产品的全部权限'),
          // SizedBox(
          //   height: 4,
          // ),
          _itemRadio("默认菜单", 2, onChanged: onChanged),
          _radioSecondTitle('角色默认具有它关联产品的默认权限'),
        ],
      ),
    );
  }

  Widget _itemRadio(String name, int num,
      {required ValueChanged<int?> onChanged}) {
    return StyleWidget.itemRadio(
      num,
      state.radioIndex,
      name,
      (value) {
        onChanged(value);
      },
    );
  }

  ///状态 switch
  Widget itemBottomSwitch() {
    return FormRow(
      title: "状态",
      vCap: 6,
      child: Row(
        children: [
          Expanded(
            child: Text(
              state.switchState ? '启用' : '禁用',
              style: TextStyle(fontSize: 16.0, fontWeight: FontWeight.bold),
            ),
          ),
          Transform.scale(
            scale: 0.8,
            child: StyleWidget.switchButton(
              state.switchState,
              (value) {
                logic.switchChange(value);
              },
            ),
          ),
        ],
      ),
    );
  }

  Widget _radioSecondTitle(String title) {
    return Container(
      margin: EdgeInsets.only(left: 20),
      child: Text(
        title,
        style: TextStyle(color: Color(0xFF909399), fontSize: 12),
      ),
    );
  }

  ///删除按钮
  Widget _deleteBtn() {
    return Visibility(
      visible: hasMenuPermission('btn_delete_role_'),
      child: Container(
        width: double.infinity,
        margin: EdgeInsets.only(top: 30),
        color: Colors.white,
        padding: EdgeInsets.symmetric(vertical: 5),
        child: TextButton(
          onPressed: () {
            ConfirmDialog(
              content: '确定移除此角色',
              confirm: () {
                logic.deleteRoleRequest();
              },
            ).show();
          },
          child: Text(
            "移除此角色",
            style: RTextStyle.deleteButtonStyle,
          ),
        ),
      ),
    );
  }
}
