import 'package:account_center/common/product_menu_control.dart';
import 'package:account_center/common/res/text_style.dart';
import 'package:account_center/common/utils/image_load.dart';
import 'package:account_center/page/account_company/company_auth/widget/common/gesture_tap.dart';
import 'package:account_center/style/svg_path.dart';
import 'package:account_center/style/widget/bottom_safe_layout.dart';
import 'package:account_center/style/widget/button_public_radius.dart';
import 'package:account_center/style/widget/my_app_bar.dart';
import 'package:account_center/widget/search_bar.dart';
import 'package:flutter/material.dart';
import 'package:flutter_clx_base/flutter_clx_base.dart';
import 'package:flutter_clx_base/widget/my_refresh_list_public.dart';

import 'role_management_logic.dart';

///企业管理-角色管理-角色管理列表 Page
class RoleManagementPage extends StatelessWidget {
  final logic = Get.find<RoleManagementLogic>();
  final state = Get.find<RoleManagementLogic>().state;

  RoleManagementPage({super.key});

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: MyAppBar('角色管理'),
      body: _bodyContent(context),
      bottomNavigationBar: Visibility(
        visible: hasMenuPermission('btn_new_role_'),
        child: BottomLayout(
          child: ButtonPublicRadius(
            onPress: () {
              logic.goToNewRolePage();
            },
            margin: EdgeInsets.symmetric(horizontal: 15, vertical: 8),
            text: '新建角色',
          ),
        ),
      ),
    );
  }

  Widget _bodyContent(context) {
    return GetBuilder<RoleManagementLogic>(builder: (controller) {
      return Column(
        children: [
          Container(
            color: Colors.white,
            child: MySearchBar(
              hintText: '请输入角色名称',
              onChange: logic.onChange,
              onSearchClick: logic.onSearch,
              node: logic.focusNode,
            ),
          ),
          Expanded(
            child: MyListViewPublic(
              controller: logic.controller,
              itemBuilder: (context, index, item) {
                return _itemViews(item);
              },
              requestData: (page, pageSize, success, error) {
                logic.getRoleListRequest(page, pageSize, success, error);
              },
            ),
          ),
        ],
      );
    });
  }

  Widget _itemViews(item) {
    return GestureTapWidget(
      onTap: () {
        logic.goToRoleDetails(item['roleNo'] ?? '');
      },
      child: Container(
        margin: EdgeInsets.only(top: 10, left: 10, right: 10),
        padding: EdgeInsets.symmetric(horizontal: 10),
        height: 60,
        decoration: BoxDecoration(
            color: Colors.white, borderRadius: BorderRadius.circular(8)),
        child: Row(
          children: [
            ImageLoad.svgTagIconByPath(SvgPath.roleIcon()),
            SizedBox(
              width: 10,
            ),
            Expanded(
              child: Text(
                item['roleName'] ?? "",
                style: RTextStyle.mainContentStyle,
                maxLines: 2,
              ),
            ),
            Icon(
              size: 20,
              Icons.arrow_forward_ios,
              color: Colors.grey[400],
            )
          ],
        ),
      ),
    );
  }
}
