import 'package:account_center/common/product_menu_control.dart';
import 'package:account_center/common/res/colors.dart';
import 'package:account_center/common/utils/image_load.dart';
import 'package:account_center/page/enterprise/organization_structure/position_details_page/position_details_logic.dart';
import 'package:account_center/style/svg_path.dart';
import 'package:account_center/widget/no_data.dart';
import 'package:flutter/material.dart';
import 'package:flutter_clx_base/flutter_clx_base.dart';
import 'package:flutter_clx_base/widget/my_refresh_list_public.dart';

import '../../../../../widget/confirm_dialog.dart';

class RoleListPage extends StatelessWidget {
  RoleListPage({Key? key}) : super(key: key);

  final logic = Get.find<PositionDetailsLogic>();
  final state = Get.find<PositionDetailsLogic>().state;

  @override
  Widget build(BuildContext context) {
    return GetBuilder<PositionDetailsLogic>(builder: (logic) {
      return _bodyContent();
    });
  }

  Widget _bodyContent() {
    return state.noRoleList
        ? NoData()
        : MyListViewPublic(
            controller: state.roleListController,
            canLoadMore: false,
            itemBuilder: (context, index, item) {
              return _itemViews(item);
            },
            pageSize: 500,
            requestData: (page, pageSize, success, error) {
              return logic.roleListRequest(page, pageSize, success);
            },
          );
  }

  Widget _itemViews(dynamic item) {
    return Container(
      margin: EdgeInsets.only(left: 15, right: 15, bottom: 10),
      padding: EdgeInsets.only(left: 10, right: 10, top: 10, bottom: 10),
      decoration: BoxDecoration(
        borderRadius: BorderRadius.circular(8),
        color: Colors.white,
      ),
      child: Row(
        children: [
          ImageLoad.svgTagIconByPath(SvgPath.roleIcon()),
          hGap15,
          Expanded(
            child: Text(
              item['roleName'] ?? "",
              style: TextStyle(
                overflow: TextOverflow.ellipsis,
                fontSize: 18,
                color: Colors.black,
              ),
              maxLines: 2,
            ),
          ),
          Visibility(
            visible: logic.canShowBottom() &&
                (logic.fromMyDepartment
                    ? hasMenuPermission('btn_remove_position_role_my')
                    : hasMenuPermission('btn_remove_position_role')),
            child: TextButton(
              onPressed: () {
                ConfirmDialog(
                  content: '确定移除该角色？',
                  confirm: () {
                    logic.deleteRow(item);
                  },
                ).show();
              },
              child: Text(
                '移除',
                style: TextStyle(color: RColors.deleteColor),
              ),
            ),
          ),
        ],
      ),
    );
  }
}
