import 'package:account_center/common/product_menu_control.dart';
import 'package:account_center/page/enterprise/organization_structure/new_position_page/new_position_view.dart';
import 'package:account_center/page/enterprise/organization_structure/position_details_page/roleList/role_list.dart';
import 'package:account_center/page/enterprise/organization_structure/position_details_page/staffList/staff_list.dart';
import 'package:account_center/page/enterprise/organization_structure/widget/structure_top_bar.dart';
import 'package:account_center/page/staff_manager/staff_detail/indicator_roundline.dart';
import 'package:account_center/style/style_params.dart';
import 'package:account_center/style/widget/my_app_bar.dart';
import 'package:flutter/material.dart';
import 'package:flutter_clx_base/flutter_clx_base.dart';

import 'position_details_logic.dart';

///职位详情 (角色 人员)
class PositionDetailsPage extends StatelessWidget {
  final logic = Get.find<PositionDetailsLogic>();
  final state = Get.find<PositionDetailsLogic>().state;

  PositionDetailsPage({super.key});

  @override
  Widget build(BuildContext context) {
    return MyScaffold(
      appBar: MyAppBar(state.title),
      body: _bodyContent(),
    );
  }

  Widget _bodyContent() {
    return Column(
      children: [
        StructureTopBar(state.parents),
        _name(),
        vGap8,
        _tabBar(),
        vGap5,
        _tabBarView(),
        _bottomButton(),
      ],
    );
  }

  ///名称 类型
  Widget _name() {
    return GetBuilder<PositionDetailsLogic>(builder: (logic) {
      return Container(
        color: Colors.white,
        padding: EdgeInsets.only(left: 20, top: 15, bottom: 15),
        child: Row(
          children: [
            Text(
              state.position ?? '',
              style: TextStyle(fontSize: 18, fontWeight: FontWeight.bold),
            ),
            hGap20,
            Visibility(
              visible: state.type?.isNotEmpty == true,
              child: Container(
                color: Color(0x0f1F59EF),
                padding: EdgeInsets.symmetric(horizontal: 5, vertical: 3),
                child: Text(
                  state.type ?? '',
                  style: TextStyle(fontSize: 10, color: StyleParams.themeColor),
                ),
              ),
            )
          ],
        ),
      );
    });
  }

  Expanded _tabBarView() {
    return Expanded(
      child: TabBarView(
        controller: logic.controller,
        children: [
          StaffListPage(),
          RoleListPage(),
        ],
      ),
    );
  }

  Align _tabBar() {
    return Align(
      alignment: Alignment.topLeft,
      child: TabBar(
        padding: EdgeInsets.only(left: 15),
        isScrollable: true,
        indicatorSize: TabBarIndicatorSize.label,
        indicator: RoundLineIndicator(3.0),
        labelPadding: EdgeInsets.symmetric(vertical: 6, horizontal: 15),
        indicatorPadding: EdgeInsets.symmetric(horizontal: 20),
        tabs: [
          Text(
            '人员列表',
            style: tabTextStyle,
          ),
          Text(
            '角色详情',
            style: tabTextStyle,
          ),
        ],
        controller: logic.controller,
      ),
    );
  }

  Widget _bottomButton() {
    return Visibility(
      visible: logic.canShowBottom(),
      child: Container(
        padding: EdgeInsets.only(bottom: 15),
        decoration: BoxDecoration(boxShadow: const [
          BoxShadow(
            color: Color(0x05000000),
            offset: Offset(1, -2),
          )
        ], color: Colors.white),
        child: Row(
          children: []
            ..addAllIf(
                hasMenuPermission(logic.fromMyDepartment
                    ? 'btn_add_position_role_my'
                    : 'btn_add_position_role_'),
                [
                  textButton(
                    '添加角色',
                    () {
                      logic.goToRolePage();
                    },
                  ),
                  bottomBarSplitLine(),
                ])
            ..addAllIf(
                hasMenuPermission(logic.fromMyDepartment
                    ? 'btn_add_member_to_position_my'
                    : 'btn_add_member_to_position'),
                [
                  textButton(
                    '添加人员',
                    () {
                      logic.goToStaffPage();
                    },
                  ),
                  bottomBarSplitLine(),
                ])
            ..addIf(
                hasMenuPermission(logic.fromMyDepartment
                    ? 'btn_position_setting_my'
                    : 'btn_position_setting'),
                textButton(
                  '职位设置',
                  () {
                    logic.goToPositionSettingPage();
                  },
                )),
        ),
      ),
    );
  }

  Widget textButton(String title, void Function() onTab) {
    return Expanded(
      flex: 1,
      child: Center(
        child: TextButton(
          onPressed: onTab,
          child: Text(
            title,
            style: TextStyle(color: StyleParams.themeColor),
          ),
        ),
      ),
    );
  }

  Container bottomBarSplitLine() {
    return Container(
      color: Color(0xffE1E1E2),
      width: 0.5,
      height: 24,
    );
  }
}
